<?php

namespace FiloBlu\CheckoutExtend\Model;

use Magento\Quote\Model\QuoteIdMaskFactory;

class GuestDniManagement implements \FiloBlu\CheckoutExtend\Api\GuestDniManagementInterface
{

    protected $quoteIdMaskFactory;
    protected $dniManagement;
    
    public function __construct(
        QuoteIdMaskFactory $quoteIdMaskFactory,
        \FiloBlu\CheckoutExtend\Api\DniManagementInterface $dniManagement
    ) {
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        $this->dniManagement = $dniManagement;
    }

    /**
     * {@inheritDoc}
     */
    public function saveDni(
        $cartId,
        \FiloBlu\CheckoutExtend\Api\Data\DniInterface $dni
    ) {
        $quoteIdMask = $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id');
        return $this->dniManagement->saveDni($quoteIdMask->getQuoteId(),$dni);
    }
}
