<?php

/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\CheckoutExtend\Magento\Framework\View\Layout\Reader;

use Magento\Framework\View\Layout;

class Move extends \Magento\Framework\View\Layout\Reader\Move {

    public $_helper;

    public function __construct(\FiloBlu\CheckoutExtend\Helper\Data $helper) {
        $this->_helper = $helper;
    }

    /**
     * Schedule structural changes for move directive
     *
     * @param \Magento\Framework\View\Layout\ScheduledStructure $scheduledStructure
     * @param \Magento\Framework\View\Layout\Element $currentElement
     * @throws \Magento\Framework\Exception\LocalizedException
     * @return $this
     */
    protected function scheduleMove(Layout\ScheduledStructure $scheduledStructure, Layout\Element $currentElement) {

        $configPath = (string) $currentElement->getAttribute('ifconfig');
        $configActive = true;

        if ($configPath) {
            $configActive = $this->_helper->getConfigValue($configPath);
        }

        if ($configActive) {
            return parent::scheduleMove($scheduledStructure, $currentElement);
        } else {
            return $this;
        }
    }

}
