<?php

namespace FiloBlu\CheckoutExtend\Controller\Index;


use FiloBlu\CheckoutExtend\Helper\Data;
use FiloBlu\CheckoutExtend\Model\Vat;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Event\ManagerInterface;
use Magento\Quote\Model\Quote\TotalsCollector;
use Magento\Quote\Observer\Frontend\Quote\Address\VatValidator;

class ValidateVat extends Action
{

    /**
     * @var JsonFactory
     */
    protected $_resultJsonFactory;
    /**
     * @var Data
     */
    protected $helperData;
    /**
     * @var Session
     */
    protected $checkoutSession;
    protected $context;
    /**
     * Application Event Dispatcher
     *
     * @var ManagerInterface
     */
    protected $eventManager;
    /**
     * @var VatValidator
     */
    protected $vatValidator;
    /**
     * @var Vat
     */
    private $vat;
    /**
     * @var TotalsCollector
     */
    private $totalsCollector;

    /**
     * ValidateVat constructor.
     * @param Context $context
     * @param JsonFactory $resultJsonFactory
     * @param Data $helperData
     * @param Vat $vat
     * @param Session $checkoutSession
     * @param ManagerInterface $eventManager
     * @param TotalsCollector $totalsCollector
     * @param VatValidator $vatValidator
     */
    public function __construct(
        Context                                                     $context,
        JsonFactory                                                 $resultJsonFactory,
        Data                                                        $helperData,
        Vat                                                         $vat,
        Session                             $checkoutSession,
        ManagerInterface                   $eventManager,
        TotalsCollector                  $totalsCollector,
        VatValidator $vatValidator

    )
    {
        $this->helperData = $helperData;
        $this->_resultJsonFactory = $resultJsonFactory;
        parent::__construct($context);
        $this->vat = $vat;
        $this->checkoutSession = $checkoutSession;
        $this->eventManager = $eventManager;
        $this->totalsCollector = $totalsCollector;
        $this->vatValidator = $vatValidator;

    }

    public function execute()
    {
        if (!$this->getRequest()->isXmlHttpRequest() && !$this->getRequest()->getParam('ajax') && !$this->getRequest()->getParam('isAjax')) {
            return false;
        }
        $resultJson = $this->_resultJsonFactory->create();
        if ($this->getRequest()->getParam('vat-number') == null || $this->getRequest()->getParam('country-code') == null) {
            return $resultJson->setData([
                'success' => false
            ]);
        }
        $vat = trim(substr($this->getRequest()->getParam('vat-number'), 0, 20)); //relaxed validation, just cut off spam strings
        $country = trim(substr($this->getRequest()->getParam('country-code'), 0, 3)); //idem
        if (!$this->vat->isCountryInEU($country)) {
            return $resultJson->setData([
                'success' => true
            ]);
        }
        $isVatValid = $this->IsVatValidAtCheckout($vat, $country);
        if ($isVatValid) {
            $this->getDispatchEvent($vat, $country);
        }
        return $resultJson->setData([
            'success' => $isVatValid
        ]);
    }

    /**
     * @param string $vat
     * @param string $country
     * @return boolean
     */
    protected function IsVatValidAtCheckout($vat, $country) {
        return $this->vat->checkVatNumber($country, $vat)->getIsValid();
    }

    public function getResultIsValid()
    {
        $requesterCountry = '';
        $requesterVat = '';
        $data = $this->getRequest()->getParam('vat-number');
        if ($this->helperData->canValidateRequester()) {
            $requesterCountry = $this->vat->getMerchantCountryCode();
            $requesterVat = $this->vat->getMerchantVatNumber();
        }
        $result = $this->vat->checkVatNumber($this->getRequest()->getCookie('filoblu_geoip_country'), $data, $requesterCountry, $requesterVat);
        $resultValue = $result->getIsValid();
        return $resultValue;
    }

    /**
     * @param string $vat
     * @param string $country
     * @return void
     */
    public function getDispatchEvent($vat, $country)
    {
//        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
//        /** @var \Magento\Quote\Observer\Frontend\Quote\Address\VatValidator $validator */
//        $validator = $objectManager->get('\Magento\Quote\Observer\Frontend\Quote\Address\VatValidator');
        $validator = $this->vatValidator;
        $this->checkoutSession->getQuote()->getShippingAddress()->setVatId($vat);
        $resultValidator = $validator->validate($this->checkoutSession->getQuote()->getShippingAddress(), $this->checkoutSession->getQuote()->getStore());

        $this->vat->getCustomerGroupIdBasedOnVatNumber($country, $resultValidator, $this->checkoutSession->getQuote()->getStoreId());

        $this->eventManager->dispatch(
            'sales_quote_collect_totals_after',
            [
                'quote' => $this->checkoutSession->getQuote()
            ]
        );
    }
}
