<?php

namespace FiloBlu\CheckoutExtend\ConfigProvider;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Api\StoreResolverInterface;

class CheckoutConfigProvider implements ConfigProviderInterface {

    const CONFIG_PATH_AUTO_COMPLETE_ENABLED = 'filoblu_checkoutextend_section/auto_complete/enabled';
    const CONFIG_PATH_AUTO_COMPLETE_API_KEY = 'filoblu_checkoutextend_section/auto_complete/api_key';
    const CONFIG_PATH_CMS_BLOCK_CUSTOM_DUTIES_ENABLED = 'filoblu_checkoutextend_section/cms_block_custom_duties_disclaimer/enabled';
    const CONFIG_PATH_CMS_BLOCK_RASSURANCE_ENABLED = 'filoblu_checkoutextend_section/cms_block_rassurance_info/enabled';
    const CONFIG_PATH_BACK_TO_CART_ENABLED = 'filoblu_checkoutextend_section/back_to_cart/enabled';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @var array
     */
    private $regionOptions;

    /**
     * @var \Magento\Directory\Model\ResourceModel\Region\CollectionFactory
     */
    private $regionCollectionFactory;

    /**
     * @var StoreResolverInterface
     */
    private $storeResolver;

    /**
     * @var \Magento\Cms\Model\Template\FilterProvider
     */
    protected $_filterProvider;

    /**
     * Store manager
     *
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * Block factory
     *
     * @var \Magento\Cms\Model\BlockFactory
     */
    protected $_blockFactory;
    protected $customDutiesDisclaimerBlockId;
    protected $rassuranceInfoBlockId;

    protected $_checkoutSession;

    public function __construct(
      ScopeConfigInterface $scopeConfig,
      \Magento\Directory\Model\ResourceModel\Region\CollectionFactory $regionCollection,
      StoreResolverInterface $storeResolver,
      \Magento\Cms\Model\Template\FilterProvider $filterProvider,
      \Magento\Store\Model\StoreManagerInterface $storeManager,
      \Magento\Cms\Model\BlockFactory $blockFactory,
      \Magento\Checkout\Model\Session $checkoutSession,
      $customDutiesDisclaimerBlockId,
      $rassuranceInfoBlockId
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->regionCollectionFactory = $regionCollection;
        $this->storeResolver = $storeResolver;
        $this->_filterProvider = $filterProvider;
        $this->_storeManager = $storeManager;
        $this->_blockFactory = $blockFactory;
        $this->_checkoutSession = $checkoutSession;
        $this->customDutiesDisclaimerBlockId = $customDutiesDisclaimerBlockId;
        $this->rassuranceInfoBlockId = $rassuranceInfoBlockId;
    }

    /**
     * @return array
     */
    public function getConfig() {

        $storeId = $this->_storeManager->getStore()->getId();
        $cmsBlockWidgetCustomDutiesDisclaimer = $this->_blockFactory->create();
        $cmsBlockWidgetCustomDutiesDisclaimer->setStoreId($storeId)->load($this->customDutiesDisclaimerBlockId);
        $cmsBlockWidgetCustomDutiesDisclaimerHtml = "";

        if ($cmsBlockWidgetCustomDutiesDisclaimer->isActive()) {
            $cmsBlockWidgetCustomDutiesDisclaimerHtml = $this->_filterProvider->getBlockFilter()->setStoreId($storeId)->filter($cmsBlockWidgetCustomDutiesDisclaimer->getContent());
        }

        $cmsBlockRassuranceInfo = $this->_blockFactory->create();
        $cmsBlockRassuranceInfo->setStoreId($storeId)->load($this->rassuranceInfoBlockId);
        $cmsBlockRassuranceInfoHtml = "";

        if ($cmsBlockRassuranceInfo->isActive()) {
            $cmsBlockRassuranceInfoHtml = $this->_filterProvider->getBlockFilter()->setStoreId($storeId)->filter($cmsBlockRassuranceInfo->getContent());
        }

        // Current additional attribute
        //$quote =  $this->_checkoutSession->getQuote();

        // $newsletterCheck = 0;
        // $registrationCheck = 0;
        // $registrationPwd = "";

        // if ($quote) {
          // $newsletterCheck = ($quote->getIsSubscribeForNewsletter() ?: 0);
          // $registrationCheck = ($quote->getCheckoutRegistration() ?: 0);
        $registrationPwd = $this->_checkoutSession->getRegistrationPwd();
        // }

        return [
            'addressAutoComplete' => [
                'enabled' => (bool) $this->scopeConfig->getValue(
                        self::CONFIG_PATH_AUTO_COMPLETE_ENABLED, ScopeInterface::SCOPE_STORE
                ),
                'apiKey' => $this->scopeConfig->getValue(
                        self::CONFIG_PATH_AUTO_COMPLETE_API_KEY, ScopeInterface::SCOPE_STORE
                ),
                'region_options' => (bool) $this->scopeConfig->getValue(
                        self::CONFIG_PATH_AUTO_COMPLETE_ENABLED, ScopeInterface::SCOPE_STORE
                ) ? $this->getRegionOptions() : ''
            ],
            'cmsBlockCustomDutiesDisclaimerHtml' => (bool) $this->scopeConfig->getValue(self::CONFIG_PATH_CMS_BLOCK_CUSTOM_DUTIES_ENABLED, ScopeInterface::SCOPE_STORE) ? $cmsBlockWidgetCustomDutiesDisclaimerHtml : "",
            'cmsBlockRassuranceInfoHtml' => (bool) $this->scopeConfig->getValue(self::CONFIG_PATH_CMS_BLOCK_RASSURANCE_ENABLED, ScopeInterface::SCOPE_STORE) ? $cmsBlockRassuranceInfoHtml : "",
            'backToCartFromCheckout' => (bool) $this->scopeConfig->getValue(self::CONFIG_PATH_BACK_TO_CART_ENABLED, ScopeInterface::SCOPE_STORE),
            // 'newsletterCheck' => $newsletterCheck,
            // 'registrationCheck' => $registrationCheck,
            'registrationPwd' => $registrationPwd,
            'enabled_different_shipping_country' => (bool) $this->scopeConfig->getValue("general/country/enabled_different_shipping_country", ScopeInterface::SCOPE_STORE),
            'allow_shipping' => explode(',' , $this->scopeConfig->getValue("general/country/allow_shipping", ScopeInterface::SCOPE_STORE)??''),
            'european_union_countries' => explode(',' , $this->scopeConfig->getValue("general/country/eu_countries", ScopeInterface::SCOPE_STORE))
        ];
    }

    private function getRegionOptions() {
        # addAllowedCountriesFilter work only for M2 >= 2.1.8
        if (!isset($this->regionOptions)) {
            $this->regionOptions = $this->regionCollectionFactory->create()->addAllowedCountriesFilter(
                    $this->storeResolver->getCurrentStoreId()
            );
        }

        return $this->regionToOptionArray($this->regionOptions);
    }

    private function regionToOptionArray($regionCollection) {
        $options = [];
        $propertyMap = [
            'value' => 'region_id',
            'code' => 'code',
            'country_id' => 'country_id',
        ];

        foreach ($regionCollection as $item) {
            $option = [];
            foreach ($propertyMap as $code => $field) {
                $option[$code] = $item->getData($field);
            }
//            $option['label'] = $item->getName();
            $options[] = $option;
        }

        return $options;
    }

}
