<?php

namespace FiloBlu\CheckoutExtend\Block\Checkout;

class AttributeMerger extends \Magento\Checkout\Block\Checkout\AttributeMerger {

    protected function getFieldConfig(
    $attributeCode, array $attributeConfig, array $additionalConfig, $providerName, $dataScopePrefix
    ) {
        // street attribute is unique in terms of configuration, so it has its own configuration builder
        if (isset($attributeConfig['validation']['input_validation'])) {
            $validationRule = $attributeConfig['validation']['input_validation'];
            $attributeConfig['validation'][$this->inputValidationMap[$validationRule]] = true;
            unset($attributeConfig['validation']['input_validation']);
        }

        if ($attributeConfig['formElement'] == 'multiline') {
            return $this->getMultilineFieldConfigRewrite($attributeCode, $attributeConfig, $providerName, $dataScopePrefix, $additionalConfig);
        }

        $uiComponent = isset($this->formElementMap[$attributeConfig['formElement']]) ? $this->formElementMap[$attributeConfig['formElement']] : 'Magento_Ui/js/form/element/abstract';
        $elementTemplate = isset($this->templateMap[$attributeConfig['formElement']]) ? 'ui/form/element/' . $this->templateMap[$attributeConfig['formElement']] : 'ui/form/element/' . $attributeConfig['formElement'];

        $element = [
            'component' => isset($additionalConfig['component']) ? $additionalConfig['component'] : $uiComponent,
            'config' => $this->mergeConfigurationNode(
                    'config', $additionalConfig, [
                'config' => [
                    // customScope is used to group elements within a single
                    // form (e.g. they can be validated separately)
                    'customScope' => $dataScopePrefix,
                    'template' => 'ui/form/field',
                    'elementTmpl' => $elementTemplate,
                ],
                    ]
            ),
            'dataScope' => $dataScopePrefix . '.' . $attributeCode,
            'label' => $attributeConfig['label'],
            'provider' => $providerName,
            'sortOrder' => isset($additionalConfig['sortOrder']) ? $additionalConfig['sortOrder'] : $attributeConfig['sortOrder'],
            'validation' => $this->mergeConfigurationNode('validation', $additionalConfig, $attributeConfig),
            'options' => $this->getFieldOptions($attributeCode, $attributeConfig),
            'filterBy' => isset($additionalConfig['filterBy']) ? $additionalConfig['filterBy'] : null,
            'customEntry' => isset($additionalConfig['customEntry']) ? $additionalConfig['customEntry'] : null,
            'visible' => isset($additionalConfig['visible']) ? $additionalConfig['visible'] : true,
        ];

        if ($dataScopePrefix == "shippingAddress") {
            if ($attributeCode === 'country_id') {
                unset($element['options']);
                $element['deps'] = [$providerName];
                $element['imports'] = [
                    'initialOptions' => 'index = ' . $providerName . ':dictionariesShipping.' . $attributeCode,
                    'setOptions' => 'index = ' . $providerName . ':dictionariesShipping.' . $attributeCode
                ];
            }
            else if ($attributeCode === 'region_id') {
                unset($element['options']);
                $element['deps'] = [$providerName];
                $element['imports'] = [
                    'initialOptions' => 'index = ' . $providerName . ':dictionaries.' . $attributeCode,
                    'setOptions' => 'index = ' . $providerName . ':dictionaries.' . $attributeCode
                ];
            }
        }
        else {
            if ($attributeCode === 'region_id' || $attributeCode === 'country_id') {
                unset($element['options']);
                $element['deps'] = [$providerName];
                $element['imports'] = [
                    'initialOptions' => 'index = ' . $providerName . ':dictionaries.' . $attributeCode,
                    'setOptions' => 'index = ' . $providerName . ':dictionaries.' . $attributeCode
                ];
            }
        }



        if (isset($attributeConfig['value']) && $attributeConfig['value'] != null) {
            $element['value'] = $attributeConfig['value'];
        } elseif (isset($attributeConfig['default']) && $attributeConfig['default'] != null) {
            $element['value'] = $attributeConfig['default'];
        } else {
            $defaultValue = $this->getDefaultValue($attributeCode);
            if (null !== $defaultValue) {
                $element['value'] = $defaultValue;
            }
        }
        return $element;
    }

    protected function getMultilineFieldConfigRewrite($attributeCode, array $attributeConfig, $providerName, $dataScopePrefix, $additionalConfig) {
        $lines = [];
        unset($attributeConfig['validation']['required-entry']);
        for ($lineIndex = 0; $lineIndex < (int) $attributeConfig['size']; $lineIndex++) {
            $isFirstLine = $lineIndex === 0;
            $line = [
                'component' => 'Magento_Ui/js/form/element/abstract',
                'config' => [
                    // customScope is used to group elements within a single form e.g. they can be validated separately
                    'customScope' => $dataScopePrefix,
                    'template' => 'ui/form/field',
                    'elementTmpl' => 'ui/form/element/input'
                ],
                'dataScope' => $lineIndex,
                'provider' => $providerName,
                'validation' => $isFirstLine ? array_merge(
                        ['required-entry' => (bool) $attributeConfig['required']], $attributeConfig['validation']
                ) : $attributeConfig['validation'],
                'additionalClasses' => $isFirstLine ? 'field' : 'additional'
            ];
            if ($isFirstLine && isset($attributeConfig['default']) && $attributeConfig['default'] != null) {
                $line['value'] = $attributeConfig['default'];
            }
            if ($isFirstLine) {
                $line["config"] = $this->mergeConfigurationNode(
                        'config', $additionalConfig, [
                    'config' => [
                        // customScope is used to group elements within a single form e.g. they can be validated separately
                        'customScope' => $dataScopePrefix,
                        'template' => 'ui/form/field',
                        'elementTmpl' => 'ui/form/element/input'
                    ],
                        ]
                );
            }
            $lines[] = $line;
        }
        return [
            'component' => 'Magento_Ui/js/form/components/group',
            'label' => $attributeConfig['label'],
            'required' => (bool) $attributeConfig['required'],
            'dataScope' => $dataScopePrefix . '.' . $attributeCode,
            'provider' => $providerName,
            'sortOrder' => $attributeConfig['sortOrder'],
            'type' => 'group',
            'config' => [
                'template' => 'ui/group/group',
                'additionalClasses' => $attributeCode
            ],
            'children' => $lines,
        ];
    }

}
