define([
	'jquery',
	'Magento_Ui/js/form/element/abstract',
	'Magento_Checkout/js/model/payment/additional-validators',
	'FiloBlu_CheckoutExtend/js/model/dni_validator',
	'Magento_Checkout/js/model/quote',
	'ko'
], function ($,Component,additionalValidators,dniValidator,quote,ko){
	'use strict';
	
	additionalValidators.registerValidator(dniValidator);

    return Component.extend({
		onElementRender:function(){
			var self = this;

			ko.computed(function(){
				var shippingAddress = quote.shippingAddress();

                if(!shippingAddress){
					return false;
				}

				self.checkHideDni(shippingAddress.countryId,shippingAddress.postcode);
            },this);
		},
		checkHideDni(countryId,postCode){
			var dni = $('[name="billingAddress.custom_attributes.dni"]');

			if(!((countryId == "ES" && this.checkPostCode(postCode)) || $.inArray(countryId,['IC','EA']) != -1)){
				dni.addClass('no-display');
			} else{
				if(dni.hasClass('no-display')){
					dni.removeClass('no-display');
				}
			}
		},
		checkPostCode:function(postCode){
			return $.isNumeric(postCode) && ((postCode >= 35000 && postCode <= 35999) || (postCode >= 38000 && postCode <= 38999) || (postCode >= 51000 && postCode <= 51999) || (postCode >= 52000 && postCode <= 52999));
		}
    });
});
