<?php

namespace FiloBlu\CheckoutExtend\Setup;

use Magento\Cms\Model\BlockFactory;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

class UpgradeData implements UpgradeDataInterface {

    /**
     * @var BlockFactory
     */
    protected $blockFactory;

    public function __construct(BlockFactory $blockFactory, \Magento\Framework\App\State $state) {
        try {
            $state->getAreaCode();
        } catch (\Exception $ex) {
            $state->setAreaCode('adminhtml');
        }

        $this->blockFactory = $blockFactory;
    }

    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context) {

        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.0.1') < 0) {

            $cmsBlockData = [
                'title' => 'Custom Duties Disclaimer',
                'identifier' => 'custom_duties_disclaimer',
                'content' => "<p>SHIPPING OUTSIDE OF THE EU?</p><p>PLEASE NOTE THAT YOU MAY BE CHARGED A TAX AND DUTIES FEE! AS THE RECIPIENT, YOU ARE LIABLE FOR ALL IMPORT DUTIES/EXPENSES LEVIED BY THE COUNTRY YOU ARE SHIPPING TO. UNFORTUNATELY, WE ARE UNABLE TO ADVISE OR PREDICT THE AMOUNT AND HAVE NO CONTROL OR INFLUENCE OVER THIS.</p>",
                'is_active' => 1,
                'stores' => 0,
                'sort_order' => 0
            ];

            $block = $this->blockFactory->create();
            $block->setData($cmsBlockData)->save();
        }

        if (version_compare($context->getVersion(), '1.0.2') < 0) {

            $cmsBlockData = [
                'title' => 'Rassurance Info',
                'identifier' => 'rassurance_info',
                'content' => '<div class="rassurance_info">
                              <div class="rassurance_info rassurance_info_1"><h4>Hai Bisogno Di Aiuto?</h4><span>Chiamaci gratuitamente al <strong>+39123456789</strong>. Siamo a tua disposizione dal Lunedì al Venerdì dalle 8:30 - 13:00 e dalle 14:00 - 18:00</span></div>
                              <div class="rassurance_info rassurance_info_2"><h4>Spedizioni in 24-48H</h4><span>Acquista comodamente da casa i tuoi prodotti. <br><strong>Spedizioni veloci in 24-48H</strong> per i tuoi ordini.</span></div>
                              <div class="rassurance_info rassurance_info_3"><h4>Shopping sicuro</h4><span>Scegli il metodo di pagamento che preferisci.<br>La <strong>massima sicurezza</strong> per i tuoi pagamenti online.</span></div>
                              </div>',
                'is_active' => 1,
                'stores' => 0,
                'sort_order' => 0
            ];

            $block = $this->blockFactory->create();
            $block->setData($cmsBlockData)->save();
        }

        if (version_compare($context->getVersion(), '1.0.3') < 0) {

            $cmsBlockData = [
                'title' => 'Checkout Newsletter Subscription',
                'identifier' => 'checkout_newsletter_subscription',
                'content' => '<p style="display: inline;">As an interested party, having read the <a href="{{store url="privacy-and-cookie-policy/"}}">Privacy Policy</a> statement drawn up pursuant to art. 13 D.Lgs. 196/2003 and subsequent amendments, I expressly consent to the processing of my personal data for commercial purposes by COMPANY NAME, including sending marketing communications (using telematic methods - such as for example newsletters and e- mail with invitations and commercial communications - and traditional methods, such as paper mail)</p>',
                'is_active' => 1,
                'stores' => 0,
                'sort_order' => 0
            ];

            $block = $this->blockFactory->create();
            $block->setData($cmsBlockData)->save();

            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("quote"), 'is_subscribe_for_newsletter', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        'comment' => 'is_subscribe_for_newsletter'
                            ]
            );
        }

        if (version_compare($context->getVersion(), '1.0.4') < 0) {

            $cmsBlockData = [
                'title' => 'Checkout Registration',
                'identifier' => 'checkout_registration',
                'content' => '<p style="display: inline;">As an interested party, having read the <a href="{{store url="privacy-and-cookie-policy"}}">Privacy Policy</a> made pursuant to art. 13 D.Lgs. 196/2003 and s.m.i., expressly consent to the processing of my personal data for registration on the Site.</p>',
                'is_active' => 1,
                'stores' => 0,
                'sort_order' => 0
            ];

            $block = $this->blockFactory->create();
            $block->setData($cmsBlockData)->save();

            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("quote"), 'checkout_registration', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        'comment' => 'checkout_registration'
                            ]
            );
        }

        if (version_compare($context->getVersion(), '1.0.5') < 0) {

            // Quote
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("quote"), 'checkout_invoice', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        'comment' => 'checkout_invoice'
                            ]
            );
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("quote"), 'checkout_invoice_fiscal_code', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 50,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_fiscal_code'
                            ]
            );
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("quote"), 'checkout_invoice_vat_number', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 50,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_vat_number'
                            ]
            );

            // Order
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("sales_order"), 'checkout_invoice', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        'comment' => 'checkout_invoice'
                            ]
            );
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("sales_order"), 'checkout_invoice_fiscal_code', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 50,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_fiscal_code'
                            ]
            );
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("sales_order"), 'checkout_invoice_vat_number', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 50,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_vat_number'
                            ]
            );
        }

        if (version_compare($context->getVersion(), '1.0.6') < 0) {

            // Quote
           
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("quote"), 'checkout_invoice_business_name', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 200,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_business_name'
                            ]
            );
            
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("quote"), 'checkout_invoice_pec', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 100,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_pec'
                            ]
            );

            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("quote"), 'checkout_invoice_sdi', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 15,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_sdi'
                            ]
            );

            // Order
         
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("sales_order"), 'checkout_invoice_business_name', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 200,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_business_name'
                            ]
            );
           
            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("sales_order"), 'checkout_invoice_pec', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 100,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_pec'
                            ]
            );

            $setup->getConnection()
                    ->addColumn(
                            $setup->getTable("sales_order"), 'checkout_invoice_sdi', [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 15,
                        'nullable' => true,
                        'comment' => 'checkout_invoice_sdi'
                            ]
            );
		}
		
		if (version_compare($context->getVersion(), '1.0.8') < 0) {

			$setup
				->getConnection()
				->addColumn(
					$setup->getTable("quote"), 'dni', [
						'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						'length' => 20,
						'nullable' => true,
						'comment' => 'DNI'
					]
				);
         
			$setup
				->getConnection()
				->addColumn(
					$setup->getTable("sales_order"), 'dni', [
						'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						'length' => 20,
						'nullable' => true,
						'comment' => 'DNI'
					]
            	);
		}


        $setup->endSetup();
    }

}
