<?php

namespace FiloBlu\CheckoutExtend\Model\Plugin\Checkout;

use Magento\Quote\Model\QuoteRepository;
use Magento\Checkout\Model\ShippingInformationManagement as ShippingManagement;
use Magento\Checkout\Api\Data\ShippingInformationInterface;

class ShippingInformationManagement {

    protected $_helper;
    protected $_quoteRepository;
    protected $_checkoutSession;

    public function __construct(
    QuoteRepository $quoteRepository, \FiloBlu\CheckoutExtend\Helper\Data $helper, \Magento\Checkout\Model\Session $checkoutSession
    ) {
        $this->_quoteRepository = $quoteRepository;
        $this->_helper = $helper;
        $this->_checkoutSession = $checkoutSession;
    }

    /**
     * @param ShippingManagement $subject
     * @param $cartId
     * @param ShippingInformationInterface $addressInformation
     */
    public function beforeSaveAddressInformation(
    ShippingManagement $subject, $cartId, ShippingInformationInterface $addressInformation
    ) {

        $shippingAddress = $addressInformation->getShippingAddress();
        $extAttributes = $shippingAddress->getExtensionAttributes();
        $this->_checkoutSession->setRegistrationPwd(null);

        if ($this->_helper->getConfigValue("filoblu_checkoutextend_section/newsletter/enabled")) {

            if ($extAttributes) {
                $newsletterSubscribe = $extAttributes->getIsSubscribeForNewsletter() ? 1 : 0;
                $quote = $this->_quoteRepository->getActive($cartId);
                $quote->setIsSubscribeForNewsletter($newsletterSubscribe);
            }
        }

        if ($this->_helper->getConfigValue("filoblu_checkoutextend_section/registration/enabled")) {
           
            if ($extAttributes) {
                $checkoutRegistration = $extAttributes->getCheckoutRegistration() ? 1 : 0;
                $quote = $this->_quoteRepository->getActive($cartId);
                $quote->setCheckoutRegistration($checkoutRegistration);
                $this->_checkoutSession->setRegistrationPwd($extAttributes->getRegistrationPwd());
            }
        }
    }

}
