<?php
namespace FiloBlu\CheckoutExtend\Model;

use Magento\Quote\Model\QuoteIdMaskFactory;

class GuestInvoiceManagement implements \FiloBlu\CheckoutExtend\Api\GuestInvoiceManagementInterface
{

    protected $quoteIdMaskFactory;
    protected $invoiceManagement;
    
    public function __construct(
        QuoteIdMaskFactory $quoteIdMaskFactory,
        \FiloBlu\CheckoutExtend\Api\InvoiceManagementInterface $invoiceManagement
    ) {
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        $this->invoiceManagement = $invoiceManagement;
    }

    /**
     * {@inheritDoc}
     */
    public function saveInvoice(
        $cartId,
        \FiloBlu\CheckoutExtend\Api\Data\InvoiceInterface $invoice
    ) {
        $quoteIdMask = $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id');
        return $this->invoiceManagement->saveInvoice($quoteIdMask->getQuoteId(), $invoice);
    }
}
