<?php

namespace FiloBlu\CheckoutExtend\Model;

use Magento\Framework\Exception\CouldNotSaveException;

class DniManagement implements \FiloBlu\CheckoutExtend\Api\DniManagementInterface
{
    protected $quoteRepository;

    public function __construct(
        \Magento\Quote\Api\CartRepositoryInterface $quoteRepository
    ) {
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * {@inheritDoc}
     */
    public function saveDni(
        $cartId,
        \FiloBlu\CheckoutExtend\Api\Data\DniInterface $dni
    ) {
        $quote = $this->quoteRepository->getActive($cartId);
        
		$dniValue = $dni->getValue();

        try {
            $quote->setData('dni',$dniValue);
            $this->quoteRepository->save($quote);
        } catch (\Exception $e) {
            throw new CouldNotSaveException(__($e->getMessage()));
        }

        return true;
    }
    
}
