<?php

namespace FiloBlu\CheckoutExtend\Model\Data;

use FiloBlu\CheckoutExtend\Api\Data\InvoiceInterface;
use Magento\Framework\Api\AbstractSimpleObject;

class Invoice extends AbstractSimpleObject implements InvoiceInterface {

     /**
     * @return bool|null
     */
    public function getFlagInvoice()
    {
        return $this->_get("flag_invoice");
    }

    /**
     * @param bool $flagInvoice
     * @return $this
     */
    public function setFlagInvoice($flagInvoice)
    {
        return $this->setData('flag_invoice', $flagInvoice);
    }
    
     /**
     * @return string|null
     */
    public function getFiscalCode()
    {
        return $this->_get("fiscal_code");
    }

    /**
     * @param string $fiscalCode
     * @return $this
     */
    public function setFiscalCode($fiscalCode)
    {
        return $this->setData('fiscal_code', $fiscalCode);
    }
    
     /**
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->_get("vat_number");
    }

    /**
     * @param string $vatNumber
     * @return $this
     */
    public function setVatNumber($vatNumber)
    {
        return $this->setData('vat_number', $vatNumber);
    }

     /**
     * @return string|null
     */
    public function getBusinessName()
    {
        return $this->_get("business_name");
    }

    /**
     * @param string $businessName
     * @return $this
     */
    public function setBusinessName($businessName)
    {
        return $this->setData('business_name', $businessName);
    }

     /**
     * @return string|null
     */
    public function getPec()
    {
        return $this->_get("pec");
    }

    /**
     * @param string $pec
     * @return $this
     */
    public function setPec($pec)
    {
        return $this->setData('pec', $pec);
    }

     /**
     * @return string|null
     */
    public function getSdi()
    {
        return $this->_get("sdi");
    }

    /**
     * @param string $sdi
     * @return $this
     */
    public function setSdi($sdi)
    {
        return $this->setData('sdi', $sdi);
    }
    
}
