<?php

namespace FiloBlu\CheckoutExtend\Block\Plugin\Checkout;

class LayoutProcessor {

    public $_helper;
    protected $_filterProvider;
    protected $_storeManager;
    protected $_blockFactory;
    protected $_customerSession;
    protected $_subscriberFactory;

    public function __construct(
        \FiloBlu\CheckoutExtend\Helper\Data $helper,
        \Magento\Cms\Model\Template\FilterProvider $filterProvider,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Cms\Model\BlockFactory $blockFactory,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory
    ) {
        $this->_helper = $helper;
        $this->_filterProvider = $filterProvider;
        $this->_storeManager = $storeManager;
        $this->_blockFactory = $blockFactory;
        $this->_customerSession = $customerSession;
        $this->_subscriberFactory = $subscriberFactory;
    }

    public function aroundProcess($subject, \Closure $proceed, $jsLayout) {

        $storeId = $this->_storeManager->getStore()->getId();

        # Shipping Additional Data
        $_shippingAdditionalData = $this->_helper->getShippingAddressAdditionalData();

        if ($_shippingAdditionalData && count($_shippingAdditionalData)) {

            foreach ($_shippingAdditionalData as $_additionalData) {
                if ($_additionalData['data_region'] == "tooltip") {
                    $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']
                            ['children']['shippingAddress']['children']['shipping-address-fieldset']
                            ['children'][$_additionalData['input_code']]['config'][$_additionalData['data_region']]["description"] = $_additionalData['label'];
                } else {
                    $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']
                            ['children']['shippingAddress']['children']['shipping-address-fieldset']
                            ['children'][$_additionalData['input_code']]['config'][$_additionalData['data_region']] = $_additionalData['label'];
                }
            }
        }

        # Move Coupon Into Totals
        if ($this->_helper->getConfigValue("filoblu_checkoutextend_section/totals/move_coupon_into_totals")) {
            $jsLayout['components']['checkout']['children']['steps']['children']['billing-step']
                    ['children']['payment']['children']['afterMethods']
                    ['children']['discount']['config']["componentDisabled"] = true;
            $jsLayout['components']['checkout']['children']['sidebar']['children']['summary']
                    ['children']['itemsBefore']['children']['discount'] = [
                'component' => 'FiloBlu_CheckoutExtend/js/view/payment/discount',
                'sortOrder' => 0,
                'children' => [
                    'errors' => [
                        'component' => 'Magento_SalesRule/js/view/payment/discount-messages',
                        'sortOrder' => 0,
                        'displayArea' => 'messages',
                    ],
                ],
            ];
        }

        if ($this->_helper->getConfigValue("filoblu_checkoutextend_section/newsletter/enabled") && !$this->customerAlreadySubscribed()) {


            $cmsBlockCheckoutNewsletterSubscription = $this->_blockFactory->create();
            $cmsBlockCheckoutNewsletterSubscription->setStoreId($storeId)->load("checkout_newsletter_subscription");
            $cmsBlockCheckoutNewsletterSubscriptionHtml = "";

            if ($cmsBlockCheckoutNewsletterSubscription->isActive()) {
                $cmsBlockCheckoutNewsletterSubscriptionHtml = $this->_filterProvider->getBlockFilter()->setStoreId($storeId)->filter($cmsBlockCheckoutNewsletterSubscription->getContent());
            }

            $is_subscribe_for_newsletter = [
                'component' => 'Magento_Ui/js/form/element/boolean',
                'config' => [
                    // customScope is used to group elements within a single form (e.g. they can be validated separately)
                    'customScope' => 'shippingAddress.custom_attributes',
                    'customEntry' => null,
                    'template' => 'ui/form/field',
                    'elementTmpl' => 'FiloBlu_CheckoutExtend/ui/form/element/newsletter_checkbox',
                ],
                'dataScope' => 'shippingAddress.custom_attributes.is_subscribe_for_newsletter',
                'label' => __('Sign up to our newsletter'),
                'description' => $cmsBlockCheckoutNewsletterSubscriptionHtml,
                'provider' => 'checkoutProvider',
                'sortOrder' => 1,
                'options' => [],
                'filterBy' => null,
                'customEntry' => null,
                'visible' => true,
            ];

//            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']['shippingAddress']['children']['before-fields']['children']['is_subscribe_for_newsletter'] = $is_subscribe_for_newsletter;
            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']['shippingAddress']['children']['before-form']['children']['is_subscribe_for_newsletter'] = $is_subscribe_for_newsletter;
//            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']['is_subscribe_for_newsletter'] = $is_subscribe_for_newsletter;
        }

        if ($this->_helper->getConfigValue("filoblu_checkoutextend_section/registration/enabled") && !$this->_customerSession->isLoggedIn()) {

            // Change email template and component
            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']['shippingAddress']['children']['customer-email']['template'] = "FiloBlu_CheckoutExtend/ui/form/element/email";
            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']['shippingAddress']['children']['customer-email']['component'] = "FiloBlu_CheckoutExtend/js/view/form/element/email";

            $cmsBlockCheckoutRegistration = $this->_blockFactory->create();
            $cmsBlockCheckoutRegistration->setStoreId($storeId)->load("checkout_registration");
            $cmsBlockCheckoutRegistrationHtml = "";

            if ($cmsBlockCheckoutRegistration->isActive()) {
                $cmsBlockCheckoutRegistrationHtml = $this->_filterProvider->getBlockFilter()->setStoreId($storeId)->filter($cmsBlockCheckoutRegistration->getContent());
            }

            $registration_checkbox = [
                'component' => 'FiloBlu_CheckoutExtend/js/view/form/element/registration_checkbox',
                'config' => [
                    // customScope is used to group elements within a single form (e.g. they can be validated separately)
                    'customScope' => 'shippingAddress.custom_attributes',
                    'customEntry' => null,
                    'template' => 'FiloBlu_CheckoutExtend/ui/form/registration_field',
                    'elementTmpl' => 'FiloBlu_CheckoutExtend/ui/form/element/registration_checkbox',
                ],
                'dataScope' => 'shippingAddress.custom_attributes.checkout_registration',
                'label' => __('Create an account'),
                'description' => $cmsBlockCheckoutRegistrationHtml,
                'dataPasswordMinLength' => $this->_helper->getConfigValue(\Magento\Customer\Model\AccountManagement::XML_PATH_MINIMUM_PASSWORD_LENGTH),
                'dataPasswordMinCharacterSets' => $this->_helper->getConfigValue(\Magento\Customer\Model\AccountManagement::XML_PATH_REQUIRED_CHARACTER_CLASSES_NUMBER),
                'provider' => 'checkoutProvider',
                'sortOrder' => 1,
                'options' => [],
                'filterBy' => null,
                'customEntry' => null,
                'visible' => true,
            ];

//            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']['shippingAddress']['children']['before-fields']['children']['is_subscribe_for_newsletter'] = $is_subscribe_for_newsletter;
            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']['shippingAddress']['children']['customer-email']['children']['after-email-field']['children']['registration'] = $registration_checkbox;
//            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']['is_subscribe_for_newsletter'] = $is_subscribe_for_newsletter;
        }
        
        if ($this->_helper->getConfigValue("filoblu_checkoutextend_section/invoice/enabled")) {

            $cmsBlockCheckoutInvoiceDescription = $this->_blockFactory->create();
            $cmsBlockCheckoutInvoiceDescription->setStoreId($storeId)->load("checkout_invoice_description");
            $cmsBlockCheckoutInvoiceDescriptionHtml = "";

            if ($cmsBlockCheckoutInvoiceDescription->isActive()) {
                $cmsBlockCheckoutInvoiceDescriptionHtml = $this->_filterProvider->getBlockFilter()->setStoreId($storeId)->filter($cmsBlockCheckoutInvoiceDescription->getContent());
            }

            $invoice_checkbox = [
                'component' => 'FiloBlu_CheckoutExtend/js/view/form/element/invoice_checkbox',
                'config' => [
                    // customScope is used to group elements within a single form (e.g. they can be validated separately)
                    'customScope' => 'billingAddress.custom_attributes',
                    'customEntry' => null,
                    'template' => 'FiloBlu_CheckoutExtend/ui/form/invoice_field',
                    'elementTmpl' => 'FiloBlu_CheckoutExtend/ui/form/element/invoice_checkbox',
                    'vatValidationUrl' => $this->_helper->getVatValidationUrl()
                ],
                'dataScope' => 'billingAddress.custom_attributes.checkout_invoice',
                'label' => __('Request an invoice'),
                'description' => __('Request an invoice'),
                'additionalDescription' => $cmsBlockCheckoutInvoiceDescriptionHtml,
                'provider' => 'checkoutProvider',
                'sortOrder' => 2,
                'options' => [],
                'filterBy' => null,
                'customEntry' => null,
                'visible' => true,
            ];

            $jsLayout['components']['checkout']['children']['steps']['children']['billing-step']['children']['payment']['children']['afterMethods']['children']['invoice'] = $invoice_checkbox;
		}
		
		if ($this->_helper->getConfigValue("filoblu_checkoutextend_section/dni/enabled")) {
			
            $_dniField = [
				'component' => 'FiloBlu_CheckoutExtend/js/view/form/element/dni',
                'config' => [
					// customScope is used to group elements within a single form (e.g. they can be validated separately)
                    'customScope' => 'billingAddress.custom_attributes',
                    'template' => 'FiloBlu_CheckoutExtend/ui/form/dni_field',
					'elementTmpl' => 'FiloBlu_CheckoutExtend/ui/form/element/dni'
				],
				'dataScope' => 'billingAddress.custom_attributes.dni',
				'label' => __('DNI'),
				'description' => __('DNI'),
                'provider' => 'checkoutProvider',
				'visible' => true,
				'sortOrder' => 3
            ];

            $jsLayout['components']['checkout']['children']['steps']['children']['billing-step']['children']['payment']['children']['afterMethods']['children']['dni'] = $_dniField;
        }

        $customJsLayout = $proceed($jsLayout);

        return $customJsLayout;
    }

    private function customerAlreadySubscribed() {

        $isSubscribed = false;

        if ($this->_customerSession->isLoggedIn()) {
            $email = $this->_customerSession->getCustomerDataObject()->getEmail();

            $subscriber = $this->_subscriberFactory->create()->loadByEmail($email);

            if ($subscriber->getSubscriberStatus() == \Magento\Newsletter\Model\Subscriber::STATUS_SUBSCRIBED) {
                $isSubscribed = true;
            }
        }

        return $isSubscribed;
    }

}
