<?php 
  
namespace FiloBlu\AdyenExchangeRate\Setup;

use Magento\Framework\Setup\InstallSchemaInterface; 
use Magento\Framework\Setup\ModuleContextInterface; 
use Magento\Framework\Setup\SchemaSetupInterface; 
use Magento\Framework\DB\Ddl\Table; 
  
class InstallSchema implements InstallSchemaInterface {
    
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context) {
        $installer = $setup;
        $installer->startSetup();
  
        $tableName = $installer->getTable('adyen_exchange_rate');
        if ($installer->getConnection()->isTableExists($tableName) != true) {
            $table = $installer->getConnection()
                ->newTable($tableName)
                ->addColumn(
                    'rate_id', 
                    Table::TYPE_INTEGER, 
                    null, 
                    [ 
                        'identity' => true,
                        'unsigned' => true, 
                        'nullable' => false, 
                        'primary' => true 
                    ], 
                    'Exchange Rate ID' 
                ) 
                ->addColumn(
                    'day_date', 
                    Table::TYPE_DATE, 
                    null, 
                    [ 
                        'nullable' => false
                    ], 
                    'Date' 
                )                
                ->addColumn(
                    'currency', 
                    Table::TYPE_TEXT,
                    '3',
                    [
                        'nullable' => false
                    ], 
                    'Currency identifier' 
                )
                ->addColumn(
                    'rate',
                    Table::TYPE_DECIMAL,
                    [12, 4],
                    [],
                    'Conversion rate'
                )
                ->addIndex(
                    $installer->getIdxName('adyen_exchange_rate', ['day_date', 'currency']), 
                    ['day_date', 'currency'],
                    ['type' => 'UNIQUE']
                )                          
                ->setComment('Adyen Currency Exchange Rates') 
                ->setOption('type', 'InnoDB') 
                ->setOption('charset', 'utf8'); 
            $installer->getConnection()->createTable($table); 
        }

        $installer->endSetup(); 
    } 
}