<?php

namespace FiloBlu\AdyenExchangeRate\Console;

use FiloBlu\AdyenExchangeRate\Model\OrderProcessor;
use Magento\Framework\App\State;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class FixOldOrder extends Command
{
    const INPUT_KEY_YEAR = 'year';

    const INPUT_TYPE_CURRENCY = 'currency';

    /**
     * @var OrderProcessor
     */
    private $orderProcessor;

    /**
     * @var State
     */
    private $state;

    public function __construct(
        OrderProcessor $orderProcessor,
        State $state
    )
    {
        $this->orderProcessor = $orderProcessor;
        $this->state = $state;
        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('filoblu:adyenexchangerate:fix-old-order')
            ->setDescription('Process orders and fix rate for specific year and currency. Retrieve rates if not present.')
            ->setDefinition($this->getInputList());
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if ($input->getArgument(self::INPUT_KEY_YEAR)) {
            $requestedYear = trim($input->getArgument(self::INPUT_KEY_YEAR));
        }

        if($input->getArgument(self::INPUT_TYPE_CURRENCY)) {
            $currency = trim($input->getArgument(self::INPUT_TYPE_CURRENCY));
        }

        $fixType = OrderProcessor::INPUT_FIX_MODE_DEFAULT;
        if(trim($input->getArgument(OrderProcessor::INPUT_FIX_MODE)) === 'query') {
            $fixType = trim($input->getArgument(OrderProcessor::INPUT_FIX_MODE));
        }

        try {
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('crontab');
        }

        $output->writeln('Fix order for year '.$requestedYear.' and currency '.$currency.'. Please waiting...');
        $this->orderProcessor->fixOrder($fixType, OrderProcessor::PERIOD_FIX_ANNUAL, $requestedYear, $currency);
        $output->writeln('');
        $output->writeln('Operation completed. Check the log file to see the affected orders');
    }

    public function getInputList()
    {
        return [
            new InputArgument(
                self::INPUT_KEY_YEAR,
                InputArgument::REQUIRED,
                'Year of orders to be processed'
            ),
            new InputArgument(
                self::INPUT_TYPE_CURRENCY,
                InputArgument::REQUIRED,
                'Currency to process'
            ),
            new InputArgument(
                OrderProcessor::INPUT_FIX_MODE,
                InputArgument::OPTIONAL,
                'Fix order using collection or direct query'
            )
        ];
    }
}
