<?php

namespace FiloBlu\AdyenExchangeRate\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

/**
 * Class UpgradeSchema
 * @package FiloBlu\AdyenExchangeRate\Setup
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * {@inheritdoc}
     */
    public function upgrade(
        SchemaSetupInterface $setup,
        ModuleContextInterface $context
    )
    {
        $setup->startSetup();

        $column_definition = [
            'type' => Table::TYPE_DECIMAL,
            'length' => '12,4',
            'nullable' => false,
            'default' => 0,
            'comment' => 'Currency exchange rate',
        ];

        $setup->getConnection()->addColumn(
            $setup->getTable('sales_order'),
            'pay_exchangerate',
            $column_definition);


        $setup->getConnection()->addColumn(
            $setup->getTable('sales_invoice'),
            'pay_exchangerate',
            $column_definition);

        $setup->endSetup();
    }
}
