<?php

namespace FiloBlu\AdyenExchangeRate\Console;

use FiloBlu\AdyenExchangeRate\Model\OrderProcessor;
use Magento\Framework\App\State;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class FixWeeklyOrder extends Command
{

    /**
     * @var OrderProcessor
     */
    private $orderProcessor;

    /**
     * @var State
     */
    private $state;

    public function __construct(
        OrderProcessor $orderProcessor,
        State $state
    )
    {
        $this->orderProcessor = $orderProcessor;
        $this->state = $state;
        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('filoblu:adyenexchangerate:fix-weekly-order')
            ->setDescription('Process and fix rate for last week order for every currencies. Retrieve rates if not present.');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('crontab');
        }

        $output->writeln("Fix last week's orders. Please waiting...");
        $this->orderProcessor->fixOrder();
        $output->writeln('');
        $output->writeln('Operation completed. Check the log file to see the affected orders');
    }
}
