<?php

namespace FiloBlu\AdyenExchangeRate\Console;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use FiloBlu\AdyenExchangeRate\Model\Retriever;

class RetrieveCommand extends Command
{
    /**
     * @var Retriever
     */
    private $retriever;
    
    /**
     *
     * @var \Magento\Framework\App\State 
     */
    private $state;
    
    const INPUT_KEY_DATE = 'date';

    /**
     * Constructor
     * @param Retriever $retriever
     */
    public function __construct(
            Retriever $retriever, 
            \Magento\Framework\App\State $state
            )
    {
        $this->retriever = $retriever;
        $this->state = $state;
        parent::__construct();
    }
 
    protected function configure()
    {
        $this
                ->setName('filoblu:adyenexchangerate:retrieve')
                ->setDescription('Retrieve currency exchange rate for a given date')
                ->setDefinition($this->getInputList());
    }
 
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if ($input->getArgument(self::INPUT_KEY_DATE)) {
            $requestedDate = trim($input->getArgument(self::INPUT_KEY_DATE));
        }
        $this->retriever->retrieveDayRates($requestedDate);
    }
 
    /**
     * Get list of options and arguments for the command
     *
     * @return mixed
     */
    public function getInputList()
    {
        return [
            new InputArgument(
                self::INPUT_KEY_DATE,
                InputArgument::REQUIRED,
                'Date to retrieve the currency exchange rates.'
            ),
        ];
    }
}