<?php

namespace FiloBlu\AdminTheme\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\View\Page\Config as PageConfig;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\UrlInterface;
use FiloBlu\AdminTheme\Helper\Data as AdminThemeHelper;
use Psr\Log\LoggerInterface;

class SetNoIndexNoFollow implements ObserverInterface
{
    /** @var PageConfig */
    protected $pageConfig;

    /** @var RequestInterface */
    protected $request;

    /** @var UrlInterface */
    protected $url;

    /** @var AdminThemeHelper */
    protected $helper;
    /**
     * @var LoggerInterface
     */
    private $logger;
    /**
     * @var \Magento\Backend\Helper\Data
     */
    private $backendHelper;

    /**
     * @param PageConfig $pageConfig
     * @param RequestInterface $request
     * @param UrlInterface $url
     * @param AdminThemeHelper $helper
     * @param LoggerInterface $logger
     */
    public function __construct(
        PageConfig $pageConfig,
        RequestInterface $request,
        UrlInterface $url,
        AdminThemeHelper $helper,
        LoggerInterface $logger,
        \Magento\Backend\Helper\Data $backendHelper
    ) {
        $this->pageConfig = $pageConfig;
        $this->request = $request;
        $this->url = $url;
        $this->helper = $helper;
        $this->logger = $logger;
        $this->backendHelper = $backendHelper;
    }

    public function execute(Observer $observer)
    {
        if (!$this->helper->isAdminMetaRobotsEnabled())
        {
            return;
        }

        try {

            $adminPath = $this->backendHelper->getAreaFrontName();

            $currentUrl = $this->sanitizeUrl($this->url->getCurrentUrl(), $adminPath);

            if (!$currentUrl) {
                return;
            }

            $adminPath = trim($this->helper->getMagentoAdminCustomUrl(), '/');

            if (!$adminPath || strpos( $adminPath, $currentUrl) === false) {
                return; // Non siamo nel backend, quindi non facciamo nulla
            }

            $robotsValue = $this->helper->getAdminMetaRobots();

            if ($robotsValue) {
                $this->pageConfig->setMetadata('robots', $robotsValue);
            }
        } catch (\Exception $e) {
            $this->logger->error($e->getMessage(), ['execption' => $e]);
            return;
        }
    }

    /**
     * Rimuove il protocollo (http/https) e il dominio dall'URL
     *
     * @param string $url
     * @return string
     */
    private function sanitizeUrl($url, $adminPath)
    {
        if (strstr($url, $adminPath)) {
            return null;
        }

        // Usa parse_url per ottenere solo il path
        $parsedUrl = parse_url($url, PHP_URL_HOST);
        return rtrim($parsedUrl, '/');
    }
}
