<?php

namespace FiloBlu\AdminTheme\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class Data extends AbstractHelper
{

    const CONFIG_IMAGE_DIR_PREFIX = 'filoblu/admintheme/';

    const XML_PATH_ADMIN_META_ROBOTS_ENABLED = 'filoblu_admintheme_section/admin_meta_robots/enabled';
    const XML_PATH_SEO_ADMIN_META_ROBOTS = 'filoblu_admintheme_section/admin_meta_robots/meta_robots';

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param Context $context
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager
    ) {
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }

    /**
     * @return string|null
     * @throws NoSuchEntityException
     */
    public function getLogoImage()
    {
        if ($this->getConfig('general/logo_image')) {
            return $this->getBaseUrlConfigImage() . $this->getConfig('general/logo_image');
        } else {
            return null;
        }
    }

    /**
     * @param string $configPath
     * @param string $section
     * @return mixed
     */
    public function getConfig($configPath, $section = 'filoblu_admintheme_section')
    {
        return $this->scopeConfig->getValue("$section/$configPath", ScopeInterface::SCOPE_STORE);
    }

    /**
     * @return string
     * @throws NoSuchEntityException
     */
    public function getBaseUrlConfigImage()
    {
        return $this->storeManager->getStore()->getBaseUrl(
                UrlInterface::URL_TYPE_MEDIA
            ) . self::CONFIG_IMAGE_DIR_PREFIX;
    }

    /**
     * @return string|null
     * @throws NoSuchEntityException
     */
    public function getLogoIconImage()
    {
        if ($this->getConfig('general/logo_icon_image')) {
            return $this->getBaseUrlConfigImage() . $this->getConfig('general/logo_icon_image');
        } else {
            return null;
        }
    }

    /**
     * @return string|null
     * @throws NoSuchEntityException
     */
    public function getBgImage()
    {
        if ($this->getConfig('general/bg_image')) {
            return $this->getBaseUrlConfigImage() . $this->getConfig('general/bg_image');
        } else {
            return null;
        }
    }

    /**
     * @return string
     */
    public function getExtraStyle()
    {
        return $this->getConfig('general/extra_style');
    }

    /**
     * @return string|null
     */
    public function isAdminMetaRobotsEnabled()
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_ADMIN_META_ROBOTS_ENABLED);
    }

    /**
     * @return string|null
     */
    public function getAdminMetaRobots()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SEO_ADMIN_META_ROBOTS);
    }

    /**
     * @return string
     */
    public function getMagentoAdminCustomUrl()
    {
        return $this->scopeConfig->getValue('admin/url/custom');
    }

}
