<?php

use FiloBlu\ActiveCampaign\Api\Data\JobsInterface;
use FiloBlu\ActiveCampaign\Model\Config\Source\EntityType;
use FiloBlu\ActiveCampaign\Model\Config\Source\Type;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\State;
use FiloBlu\ActiveCampaign\Model\JobManager;

require __DIR__ . '/../../../../../bootstrap.php';
$params = $_SERVER;
$bootstrap = Bootstrap::create(BP, $params);
$obj = $bootstrap->getObjectManager();
$state = $obj->get(State::class);
$state->setAreaCode('adminhtml');
$objectManager = ObjectManager::getInstance();

/** @var JobManager $jobManager */
$jobManager = $objectManager->get(JobManager::class);

// Subscriber
$jobManager->setEntity(EntityType::ENTITY_SUBSCRIBER);
$result = $jobManager->prepare();

print_r($result);

// Customer
$jobManager->setEntity(EntityType::ENTITY_CUSTOMER);
$jobManager->setExportType(JobsInterface::INCREMENTAL);
$result = $jobManager->prepare();

print_r($result);

// Order
$jobManager->setEntity(EntityType::ENTITY_ORDER);
$jobManager->setExportType(JobsInterface::FULL);
$result = $jobManager->prepare();

print_r($result);

// Quote
$jobManager->setEntity(EntityType::ENTITY_QUOTE);
$result = $jobManager->prepare();

print_r($result);
echo "Done\n";



