<?php

namespace FiloBlu\ActiveCampaign\Model;

use FiloBlu\ActiveCampaign\Api\Data\ListsInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Jobs
 * @package FiloBlu\ActiveCampaign\Model
 */
class Lists extends AbstractModel implements ListsInterface {

    /**
     * Construct
     */
    public function _construct()
    {
        $this->_init(ResourceModel\Lists::class);
    }

    /**
     * @return array|mixed|null
     */
    public function getId()
    {
        return $this->getData(self::ID);
    }

    /**
     * @param mixed $id
     * @return $this|Lists|mixed
     */
    public function setId($id)
    {
        $this->setData(self::ID, $id);
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getAcId()
    {
        return $this->getData(self::AC_ID);
    }

    /**
     * @param $acId
     * @return $this|mixed
     */
    public function setAcId($acId)
    {
        $this->setData(self::AC_ID, $acId);
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getName()
    {
        return $this->getData(self::NAME);
    }

    /**
     * @param $name
     * @return $this|mixed
     */
    public function setName($name)
    {
        $this->setData(self::NAME, $name);
        return $this;
    }
}