<?php

namespace FiloBlu\ActiveCampaign\Model\Entity\Import;

use Exception;
use FiloBlu\ActiveCampaign\Api\Data\JobsInterface;
use FiloBlu\ActiveCampaign\Api\Data\JobsInterfaceFactory;
use FiloBlu\ActiveCampaign\Api\JobsRepositoryInterface;
use FiloBlu\ActiveCampaign\Helper\Data;
use FiloBlu\ActiveCampaign\Model\Config\Source\JobStatus;
use FiloBlu\ActiveCampaign\Model\Entity\Import\EntityImportInterface;
use Magento\Framework\App\ResourceConnection;

/**
 * Class AbstractEntityImport
 * @package FiloBlu\ActiveCampaign\Model\Entity\Import
 */
abstract class AbstractEntityImport implements EntityImportInterface {

    /**
     * @var string
     */
    protected $entity;
    /**
     * @var string
     */
    protected $direction;
    /**
     * @var JobsInterfaceFactory
     */
    protected $jobsFactory;
    /**
     * @var string
     */
    protected $type;
    /**
     * @var string
     */
    protected $statusToProcess = JobStatus::JOB_STATUS_WAITING;
    /**
     * @var array
     */
    protected $options = [];
    /**
     * @var ResourceConnection
     */
    protected $resourceConnection;
    /**
     * @var Data
     */
    protected $helperData;
    /**
     * @var JobsRepositoryInterface
     */
    protected $jobsRepository;

    /**
     * AbstractEntityImport constructor.
     * @param ResourceConnection $resourceConnection
     * @param Data $helperData
     * @param JobsRepositoryInterface $jobsRepository
     * @param JobsInterfaceFactory $jobsFactory
     */
    public function __construct (
        ResourceConnection $resourceConnection,
        Data $helperData,
        JobsRepositoryInterface $jobsRepository,
        JobsInterfaceFactory $jobsFactory
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->helperData = $helperData;
        $this->jobsRepository = $jobsRepository;
        $this->jobsFactory = $jobsFactory;
    }

    /**
     * @return mixed|void
     */
    public function process() {
        $this->options = [
            JobsInterface::TYPE => $this->type,
            JobsInterface::DIRECTION => $this->direction,
            JobsInterface::ENTITY => $this->entity
        ];
        $success = 0;
        $error = 0;
        $jobs = $this->jobsRepository->getAll($this->options, $this->statusToProcess);
        foreach ($jobs as $job){
            try {
                //$this->jobsRepository->setStatus($options,$job['entity_id'],JobStatus::JOB_STATUS_PROCESSING);
                $resp = $this->executeProcess($job);
                if($resp) {
                    $this->jobsRepository->setStatus($this->options,$job['entity_id'],JobStatus::JOB_STATUS_PROCESSED);
                }
                $success++;
            }
            catch (Exception $exception) {
                $this->jobsRepository->setStatus($this->options,$job['entity_id'],JobStatus::JOB_STATUS_ERROR,$exception->getMessage());
                $error++;
            }
            catch (\Throwable $throwable) {
                $this->jobsRepository->setStatus($this->options,$job['entity_id'],JobStatus::JOB_STATUS_ERROR,$throwable->getMessage());
                $error++;
            }
        }
        return [$success,$error];
    }

    /**
     * @param array $updateArray
     * @param string $where
     * @return mixed|void
     */
    public function updateJobs(array $updateArray, $where = '') {
        $w = 'entity="'.$this->entity.'" AND direction="'.$this->direction.'"';
        if(!empty($where)){
            $w .= ' AND '.$where;
        }
        $this->jobsRepository->updateJobs($updateArray, $w);
    }

    /**
     * @param $type
     * @return $this
     */
    public function setType($type){
        $this->type = $type;
        return $this;
    }

    /**
     * @param $statusToProcess
     * @return $this
     */
    public function setStatusToProcess($statusToProcess) {
        $this->statusToProcess = $statusToProcess;
        return $this;
    }

}