<?php

namespace FiloBlu\ActiveCampaign\Model\Entity\Export;

/**
 * Interface EntityExportInterface
 * @package FiloBlu\ActiveCampaign\Model\Entity\Export
 */
interface EntityExportInterface {

    /**
     * @return mixed
     */
    public function prepare();

    /**
     * @return mixed
     */
    public function process();

    /**
     * @return mixed
     */
    public function getAllIncrementalIds();

    /**
     * @param array $job
     * @return bool
     */
    public function executeProcess(array $job): bool;

    /**
     * @param array $updateArray
     * @param string $where
     * @return mixed
     */
    public function updateJobs(array $updateArray, $where = '');

}