<?php

namespace FiloBlu\ActiveCampaign\Model\Connector;

use Magento\Framework\DataObject;

/**
 * Interface ConnectorInterface
 * @package FiloBlu\ActiveCampaign\Model\Connector
 */
interface ConnectorInterface {

    /**
     * @param DataObject $configuration
     * @return ConnectorInterface
     */
    public function configure(DataObject $configuration): ConnectorInterface;

    /**
     * @return ConnectorInterface
     */
    public function connect(): ConnectorInterface;

    /**
     * @return ConnectionInterface
     */
    public function disconnect(): ConnectionInterface;

    /**
     * @return DataObject
     */
    public function getConfiguration(): DataObject;

}