<?php

namespace FiloBlu\ActiveCampaign\Model\Connector;

use FiloBlu\ActiveCampaign\Helper\Data;
use Magento\Framework\DataObject;
use Magento\Framework\DataObjectFactory;
use Psr\Log\LoggerInterface;

/**
 * Class AbstractConnector
 * @package FiloBlu\ActiveCampaign\Model\Connector
 */
abstract class AbstractConnector implements ConnectorInterface {
    /**
     * @var DataObjectFactory
     */
    protected $dataObjectFactory;
    /**
     * @var LoggerInterface
     */
    protected $logger;
    /**
     * @var DataObject
     */
    protected $configuration;
    /**
     * @var Data
     */
    protected $helperData;

    /**
     * AbstractConnector constructor.
     * @param Data $helperData
     * @param DataObjectFactory $dataObjectFactory
     * @param LoggerInterface $logger
     */
    public function __construct(
        Data $helperData,
        DataObjectFactory $dataObjectFactory,
        LoggerInterface $logger
    ){

        $this->dataObjectFactory = $dataObjectFactory;
        $this->logger = $logger;
        $this->helperData = $helperData;
    }

    /**
     * @return DataObject
     */
    public function getConfiguration(): DataObject
    {
        if ($this->configuration) {
            return $this->configuration;
        }

        return ($this->configuration = $this->dataObjectFactory->create());
    }

    /**
     * @param DataObject $configuration
     * @return ConnectorInterface
     */
    public function configure(DataObject $configuration): ConnectorInterface
    {
        $this->configuration = $configuration;
        return $this;
    }


}