<?php

namespace FiloBlu\ActiveCampaign\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Type
 * @package FiloBlu\ActiveCampaign\Model\Config\Source
 */
class Type implements OptionSourceInterface
{
    /**
     * Constants
     */
    public const TYPE_REST = 'rest';
    public const TYPE_FTP = 'ftp';
    public const TYPE_AVAILABLE = [self::TYPE_REST, self::TYPE_FTP];

    /**
     * @return array|array[]
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::TYPE_REST, 'label' => __('Rest')],
            ['value' => self::TYPE_FTP, 'label' => __('Ftp')]
        ];
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return [
            self::TYPE_REST => __('Rest'),
            self::TYPE_FTP  => __('Ftp')
        ];
    }
}
