<?php

namespace FiloBlu\ActiveCampaign\Model\Config\Source;

use FiloBlu\ActiveCampaign\Api\ListsRepositoryInterface;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Lists
 * @package FiloBlu\ActiveCampaign\Model\Config\Source
 */
class Lists implements OptionSourceInterface
{
    /**
     * @var ListsRepositoryInterface
     */
    protected $listsRepository;

    /**
     * Lists constructor.
     * @param ListsRepositoryInterface $listsRepository
     */
    public function __construct(
        ListsRepositoryInterface $listsRepository
    ) {
        $this->listsRepository = $listsRepository;
    }

    /**
     * @return mixed
     */
    public function getLists() {
        return $this->listsRepository->getAll();
    }

    /**
     * @return array|array[]
     */
    public function toOptionArray()
    {
        $lists = $this->getLists();
        $result = ['value' => '', 'label' => __('-- Select a list --')];
        foreach ($lists as $list) {
            $result[] = ['value' => $list['ac_id'], 'label' => $list['name']];
        }
        return $result;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        $lists = $this->getLists();
        $result = [];
        foreach ($lists as $list) {
            $result[$list['ac_id']] = $list['name'];
        }
        return $result;
    }
}
