<?php

namespace FiloBlu\ActiveCampaign\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class JobStatus
 * @package FiloBlu\ActiveCampaign\Model\Config\Source
 */
class JobStatus implements OptionSourceInterface
{
    /**
     * Constants
     */
    public const JOB_STATUS_WAITING = 'waiting';
    public const JOB_STATUS_BULK_WAITING = 'bulk_waiting';
    public const JOB_STATUS_PROCESSING = 'processing';
    public const JOB_STATUS_PROCESSED = 'processed';
    public const JOB_STATUS_ERROR = 'error';
    public const JOB_STATUS_ERROR_NOTIFIED = 'error_notified';
    public const JOB_STATUS_SUSPENDED = 'suspended';
    public const JOB_STATUS_SKIPPED = 'skipped';
    public const JOB_STATUS_AVAILABLE = [
        self::JOB_STATUS_WAITING,
        self::JOB_STATUS_BULK_WAITING,
        self::JOB_STATUS_PROCESSED,
        self::JOB_STATUS_ERROR,
        self::JOB_STATUS_SUSPENDED,
        self::JOB_STATUS_SKIPPED
    ];

    /**
     * @return array|array[]
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::JOB_STATUS_WAITING, 'label' => __('Waiting')],
            ['value' => self::JOB_STATUS_BULK_WAITING, 'label' => __('Bulk Waiting')],
            ['value' => self::JOB_STATUS_PROCESSING, 'label' => __('Processing')],
            ['value' => self::JOB_STATUS_PROCESSED, 'label' => __('Processed')],
            ['value' => self::JOB_STATUS_ERROR, 'label' => __('Error')],
            ['value' => self::JOB_STATUS_ERROR_NOTIFIED, 'label' => __('Error Notified')],
            ['value' => self::JOB_STATUS_SUSPENDED, 'label' => __('Suspended')],
            ['value' => self::JOB_STATUS_SKIPPED, 'label' => __('Skipped')]
        ];
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return [
            self::JOB_STATUS_WAITING        => __('Waiting'),
            self::JOB_STATUS_BULK_WAITING   => __('Bulk Waiting'),
            self::JOB_STATUS_PROCESSING     => __('Processing'),
            self::JOB_STATUS_PROCESSED      => __('Processed'),
            self::JOB_STATUS_ERROR          => __('Error'),
            self::JOB_STATUS_ERROR_NOTIFIED => __('Error Notified'),
            self::JOB_STATUS_SUSPENDED      => __('Suspended'),
            self::JOB_STATUS_SKIPPED        => __('Skipped')
        ];
    }
}
