<?php

namespace FiloBlu\ActiveCampaign\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class DirectionType
 * @package FiloBlu\ActiveCampaign\Model\Config\Source
 */
class DirectionType implements OptionSourceInterface
{
    /**
     * Constants
     */
    const DIRECTION_EXPORT = "export";
    const DIRECTION_IMPORT = "import";
    const DIRECTION_AVAILABLE = [self::DIRECTION_EXPORT,self::DIRECTION_IMPORT];

    /**
     * @return array|array[]
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::DIRECTION_EXPORT, 'label' => __('Export')],
            ['value' => self::DIRECTION_IMPORT, 'label' => __('Import')]
        ];
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return [
            self::DIRECTION_EXPORT => __('Export'),
            self::DIRECTION_IMPORT => __('Import')
        ];
    }
}
