<?php

namespace FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\Customer;

use FiloBlu\ActiveCampaign\Api\FieldsRepositoryInterface;
use FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\AbstractConfig;
use Magento\Backend\Block\Template\Context;
use Magento\Customer\Model\Customer as MagentoCustomer;
use Magento\Framework\App\ResourceConnection;

/**
 * Class ActiveCampaign
 * @package FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\Customer
 */
class Customer extends AbstractConfig
{

    /**
     * Customer Object
     *
     * @var MagentoCustomer
     */
    protected $model;

    /**
     * @var string
     */
    protected $id = 'customer';

    /**
     * @var string
     */
    protected $type = 'eav';

    /**
     * @var array
     */
    protected $exclude = [
        'increment_id',
        'entity_id',
        'password_hash',
        'rp_token',
        'rp_token_created_at',
        'email',
        'firstname',
        'lastname',
        'confirmation',
        'default_billing',
        'default_shipping',
        'disable_auto_group_change',
        'failures_num',
        'first_failure',
        'lock_expires'
    ];

    /**
     * @var array
     */
    protected $additionalOptions =  [
        ['value' => '_customer_id', 'label' => '_customer_id (Customer Id)'],
        ['value' => '_store_code', 'label' => '_store_code (Store Code)'],
        ['value' => '_store_name', 'label' => '_store_name (Store Name)'],
        ['value' => '_website_code', 'label' => '_website_code (Website Code)'],
        ['value' => '_website_name', 'label' => '_website_name (Website Name)'],
        ['value' => '_type', 'label' => '_type (Type)'],
        ['value' => '_subscriber_status_normalized', 'label' => '_subscriber_status_normalized (Subscriber Status Normalized)'],
        ['value' => '_gender_normalized', 'label' => '_gender_normalized (Customer Gender Normalized)'],
        ['value' => '_created_at_normalized', 'label' => '_created_at_normalized (Customer Created At Normalized)'],
        ['value' => '_updated_at_normalized', 'label' => '_updated_at_normalized (Customer Updated At Normalized)'],
        ['value' => '_source', 'label' => '_source (Customer source)'],
        ['value' => '_language', 'label' => '_language (Customer Language)'],
        ['value' => '_language_iso2', 'label' => '_language ISO2 (Customer Language ISO2 Normalized)']
    ];

    /**
     * CustomerAttributes constructor.
     * @param MagentoCustomer $customer
     * @param Context $context
     * @param ResourceConnection $resourceConnection
     * @param FieldsRepositoryInterface $fieldsRepository
     * @param array $data
     */
    public function __construct(
        MagentoCustomer $customer,
        Context $context,
        ResourceConnection $resourceConnection,
        FieldsRepositoryInterface $fieldsRepository,
        array $data = []
    ) {
        $this->model = $customer;
        parent::__construct($context, $resourceConnection, $fieldsRepository, $data);
    }

}
