<?php

declare(strict_types=1);

namespace FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\ActiveCampaign;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\BlockInterface;

/**
 * Class Mapping
 * @package FiloBlu\DModa\Block\Adminhtml\System\Config;
 */
class MappingCustomer extends AbstractFieldArray
{

    /** @var string  */
    const ENTITY = 'customer';

    /**
     * @var bool
     */
    protected $_addAfter = false;

    /**
     * @param Context $context
     * @param array $data
     */
    public function __construct(
        Context $context,
        array   $data = []
    ) {
        parent::__construct($context, $data);
    }

    /**
     * prepare to render
     *
     * @return void
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $this->addColumn('list_id_' . self::ENTITY, [
            'label' => __('List ID'),
            'size' => '13px',
            'class' => 'required-entry'
        ]);

        $this->addColumn('store_field_' . self::ENTITY, [
            'label' => __('Store'),
            'size' => '13px',
            'class' => 'required-entry'
        ]);

        $this->addColumn('coupon_field_' . self::ENTITY, [
            'label' => __('Coupon'),
            'size' => '13px',
            'class' => 'required-entry'
        ]);

        $this->addColumn('dob_field_' . self::ENTITY, [
            'label' => __('DoB'),
            'size' => '13px',
            'class' => 'required-entry'
        ]);


        /** @var BlockInterface $paymentModesBlock */
        $enabledBlock = $this->getLayout()->createBlock('Magento\Framework\View\Element\Html\Select')
            ->setId($this->_getCellInputElementId('<%- _id %>', 'enabled_' . self::ENTITY))
            ->setName($this->_getCellInputElementName('enabled_' . self::ENTITY))
            ->setClass('select')
            ->setOptions([
                '' => '',
                '1' => 'Yes',
                '0' => 'No'
            ]);

        $this->addColumn('enabled', array(
            'label' => __('Enabled'),
            'renderer' => $enabledBlock
        ));
    }
}
