<?php

namespace FiloBlu\ActiveCampaign\Block\Adminhtml\Jobs\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class BackButton
 * @package FiloBlu\ActiveCampaign\Block\Adminhtml\Jobs\Edit
 */
class BackButton extends GenericButton implements ButtonProviderInterface
{
    /**
     * @return array
     */
    public function getButtonData()
    {
        return [
            'label' => __('Back'),
            'on_click' => sprintf("location.href = '%s';", $this->getBackUrl()),
            'class' => 'back',
            'sort_order' => 10
        ];
    }

    /**
     * @return mixed
     */
    public function getBackUrl()
    {
        return $this->getUrl('*/*/');
    }
}
