<?php

namespace FiloBlu\ActiveCampaign\Api;

use FiloBlu\ActiveCampaign\Api\Data\ListsInterface;

/**
 * Interface ListsRepositoryInterface
 * @package FiloBlu\ActiveCampaign\Api
 */
interface ListsRepositoryInterface
{
    /**
     * @param ListsInterface $lists
     * @return mixed
     */
    public function save(ListsInterface $lists);

    /**
     * @param $listId
     * @return mixed
     */
    public function getById($listId);

    /**
     * @return mixed
     */
    public function getAll();

    /**
     * @param $listId
     * @return mixed
     */
    public function deleteById($listId);

    /**
     * @return mixed
     */
    public function deleteAll();

}
