<?php

namespace FiloBlu\ActiveCampaign\Api;

use FiloBlu\ActiveCampaign\Api\Data\JobsInterface;

/**
 * Interface JobsRepositoryInterface
 * @package FiloBlu\ActiveCampaign\Api
 */
interface JobsRepositoryInterface
{
    /**
     * @param JobsInterface $jobs
     * @return mixed
     */
    public function save(JobsInterface $jobs);

    /**
     * @param $jobId
     * @return mixed
     */
    public function getById($jobId);

    /**
     * @param $options
     * @param null $status
     * @param null $limit
     * @return mixed
     */
    public function getAll($options, $status = null, $limit = null);

    /**
     * @param array $conditions
     * @return mixed
     */
    public function checkIfExist(array $conditions);

    /**
     * @param $options
     * @param $id
     * @param $status
     * @param null $log
     * @return mixed
     */
    public function setStatus($options, $id, $status, $log=null);
}
