<?php

namespace FiloBlu\ActiveCampaign\Api\Data;

/**
 * Interface JobsInterface
 * @package FiloBlu\ActiveCampaign\Api\Data
 */
interface JobsInterface
{

    /**
     * CONST
     */
    const ID = 'id';
    const TYPE = 'type';
    const DIRECTION = 'direction';
    const ENTITY = 'entity';
    const ENTITY_ID = 'entity_id';
    const REQUEST = 'request';
    const RESPONSE = 'response';
    const STATUS = 'status';
    const LOG = 'log';
    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DB_TABLE = 'filoblu_activecampaign_jobs';
    const PRIMARY_KEY = 'id';
    const INCREMENTAL = 'incremental';
    const FULL = 'full';
    const EXPORT_TYPE_AVAILABLE = [self::INCREMENTAL,self::FULL];

    /**
     * @return mixed
     */
    public function getId();

    /**
     * @param $id
     * @return mixed
     */
    public function setId($id);

    /**
     * @return mixed
     */
    public function getType();

    /**
     * @param $type
     * @return mixed
     */
    public function setType($type);

    /**
     * @return mixed
     */
    public function getDirection();

    /**
     * @param $direction
     * @return mixed
     */
    public function setDirection($direction);

    /**
     * @return mixed
     */
    public function getEntity();

    /**
     * @param $entity
     * @return mixed
     */
    public function setEntity($entity);

    /**
     * @return mixed
     */
    public function getEntityId();

    /**
     * @param $entityId
     * @return mixed
     */
    public function setEntityId($entityId);

    /**
     * @return mixed
     */
    public function getRequest();

    /**
     * @param $request
     * @return mixed
     */
    public function setRequest($request);

    /**
     * @return mixed
     */
    public function getResponse();

    /**
     * @param $response
     * @return mixed
     */
    public function setResponse($response);

    /**
     * @return mixed
     */
    public function getStatus();

    /**
     * @param $status
     * @return mixed
     */
    public function setStatus($status);

    /**
     * @return mixed
     */
    public function getLog();

    /**
     * @param $log
     * @return mixed
     */
    public function setLog($log);
}
