<?php

use FiloBlu\ActiveCampaign\Api\Data\JobsInterface;
use FiloBlu\ActiveCampaign\Model\Config\Source\EntityType;
use FiloBlu\ActiveCampaign\Model\Config\Source\JobStatus;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\State;
use FiloBlu\ActiveCampaign\Model\JobManager;

require __DIR__ . '/../../../../../bootstrap.php';
$params = $_SERVER;
$bootstrap = Bootstrap::create(BP, $params);
$obj = $bootstrap->getObjectManager();
$state = $obj->get(State::class);
$state->setAreaCode('adminhtml');
$objectManager = ObjectManager::getInstance();

/** @var JobManager $jobManager */
$jobManager = $objectManager->get(JobManager::class);

// Reset All
$result = $jobManager->reset(JobStatus::JOB_STATUS_WAITING);
print_r($result);

$result = $jobManager->reset('wrong');
print_r($result);

$result = $jobManager->reset(JobStatus::JOB_STATUS_WAITING, 'wrong');
print_r($result);

$result = $jobManager->reset(JobStatus::JOB_STATUS_WAITING, JobStatus::JOB_STATUS_WAITING);
print_r($result);

$result = $jobManager->reset(JobStatus::JOB_STATUS_WAITING, JobStatus::JOB_STATUS_ERROR, 'wrong');
print_r($result);

$result = $jobManager->reset(JobStatus::JOB_STATUS_ERROR,'',EntityType::ENTITY_ORDER);
print_r($result);

$result = $jobManager->reset(JobStatus::JOB_STATUS_BULK_WAITING, JobStatus::JOB_STATUS_ERROR);
print_r($result);

$result = $jobManager->reset(JobStatus::JOB_STATUS_SUSPENDED, '', EntityType::ENTITY_CUSTOMER);
print_r($result);



echo "Done\n";



