<?php

use FiloBlu\ActiveCampaign\Api\Data\JobsInterface;
use FiloBlu\ActiveCampaign\Model\Config\Source\EntityType;
use FiloBlu\ActiveCampaign\Model\Config\Source\JobStatus;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\State;
use FiloBlu\ActiveCampaign\Model\JobManager;

require __DIR__ . '/../../../../../bootstrap.php';
$params = $_SERVER;
$bootstrap = Bootstrap::create(BP, $params);
$obj = $bootstrap->getObjectManager();
$state = $obj->get(State::class);
$state->setAreaCode('adminhtml');
$objectManager = ObjectManager::getInstance();

/** @var JobManager $jobManager */
$jobManager = $objectManager->get(JobManager::class);

// Customer
$jobManager->setEntity(EntityType::ENTITY_CUSTOMER);
$result = $jobManager->process();
print_r($result);

// Subscriber
$jobManager->setEntity(EntityType::ENTITY_SUBSCRIBER);
$result = $jobManager->process();
print_r($result);

// Order
$jobManager->setEntity(EntityType::ENTITY_ORDER);
$result = $jobManager->process();
print_r($result);

echo "Processing ".JobStatus::JOB_STATUS_BULK_WAITING."\n\n";
$jobManager->setStatusToProcess(JobStatus::JOB_STATUS_BULK_WAITING);

// Customer
$jobManager->setEntity(EntityType::ENTITY_CUSTOMER);
$result = $jobManager->process();
print_r($result);

// Subscriber
$jobManager->setEntity(EntityType::ENTITY_SUBSCRIBER);
$result = $jobManager->process();
print_r($result);

// Order
$jobManager->setEntity(EntityType::ENTITY_ORDER);
$result = $jobManager->process();
print_r($result);

$jobManager->setEntity(EntityType::ENTITY_QUOTE);
$result = $jobManager->process();
print_r($result);



echo "Done\n";



