<?php

namespace FiloBlu\ActiveCampaign\Observer;

use FiloBlu\ActiveCampaign\Model\Config\Source\EntityType;
use Magento\Framework\Event\Observer;

/**
 * Class NewsletterSubscription
 * @package FiloBlu\ActiveCampaign\Observer
 */
class NewsletterSubscription extends AbstractObserver
{
    /**
     * @var string
     */
    protected $entity = EntityType::ENTITY_SUBSCRIBER;

    /**
     * @param Observer $observer
     * @return void
     * @throws Exception
     */
    public function execute(Observer $observer)
    {
        $entityId = $observer->getData($this->entity)->getId();

        // IF MODULE IS ENABLED
        if(!$this->helperData->isEnabled()){
            return;
        }
        // IF OBSERVER IS ENABLED
        if (!$this->helperData->isObserverEnabled()) {
            return;
        }
        // SUBSCRIBER CHANGE
        if (!$this->helperData->isSubscriptionChangeObserverEnabled()) {
            return;
        }
        // FILTER ENABLED STORES
        $subscriberStoreId = $observer->getData($this->entity)->getStoreId();
        if (!in_array($subscriberStoreId, explode(',', $this->helperData->getEnabledStoreViews()))) {
            return;
        }

        $this->writeJob($entityId);
    }

}