<?php

namespace FiloBlu\ActiveCampaign\Model;

use FiloBlu\ActiveCampaign\Api\Data\ListsInterface;
use FiloBlu\ActiveCampaign\Api\Data\ListsInterfaceFactory;
use FiloBlu\ActiveCampaign\Api\ListsRepositoryInterface;
use FiloBlu\ActiveCampaign\Helper\Data;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Phrase;
use Zend_Db;

/**
 * Class ListsRepository
 * @package FiloBlu\ActiveCampaign\Model
 */
class ListsRepository implements ListsRepositoryInterface
{
    /**
     * @var ListsInterfaceFactory
     */
    protected $listsFactory;
    /**
     * @var ResourceConnection
     */
    protected $resourceConnection;
    /**
     * @var Data
     */
    protected $helperData;


    /**
     * JobsRepository constructor.
     * @param ResourceConnection $resourceConnection
     * @param ListsInterfaceFactory $listsFactory
     * @param Data $helperData
     */
    public function __construct(
        ResourceConnection $resourceConnection,
        ListsInterfaceFactory $listsFactory,
        Data $helperData
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->helperData = $helperData;
        $this->listsFactory = $listsFactory;
    }


    /**
     * @param ListsInterface $lists
     * @return mixed|void
     */
    public function save(ListsInterface $lists)
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(ListsInterface::DB_TABLE);
        $connection->insert(
            $table,
            [
                ListsInterface::AC_ID => $lists->getAcId(),
                ListsInterface::NAME => $lists->getName()
            ]
        );

        $id = $connection->lastInsertId();
        $lists->setId($id);
    }

    /**
     * @param $listId
     * @return mixed
     * @throws NoSuchEntityException
     */
    public function getById($listId)
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(ListsInterface::DB_TABLE);
        $sql = $connection->select()->from($table, ['*'])->where('id = (?)', $listId)->assemble();
        $res = $connection->fetchRow($sql, [], Zend_Db::FETCH_ASSOC);
        if ($res===null) {
            throw new NoSuchEntityException(new Phrase('The list with id ' . $listId . ' doesn\'t exists'));
        }
        $lists = $this->listsFactory->create();
        foreach ($res as $k => $v) {
            $parse = explode('_', $k);
            $method = 'set';
            foreach ($parse as $p) {
                $method .= ucwords($p);
            }
            $lists->{$method}($v);
        }
        return $lists;
    }

    /**
     * @return array|mixed
     */
    public function getAll()
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(ListsInterface::DB_TABLE);
        $sql = $connection->select()->from($table, ['*'])->assemble();
        return $connection->fetchAll($sql, [], Zend_Db::FETCH_ASSOC);
    }

    /**
     * @param $listId
     * @return mixed|void
     */
    public function deleteById($listId)
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(ListsInterface::DB_TABLE);
        $sql = $connection->delete($table,'id = '.$listId);
    }

    /**
     * @return mixed|void
     */
    public function deleteAll()
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(ListsInterface::DB_TABLE);
        $sql = $connection->delete($table);
    }
}
