<?php

namespace FiloBlu\ActiveCampaign\Model;

use FiloBlu\ActiveCampaign\Api\Data\JobsInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Jobs
 * @package FiloBlu\ActiveCampaign\Model
 */
class Jobs extends AbstractModel implements JobsInterface {

    /**
     * Construct
     */
    public function _construct()
    {
        $this->_init(ResourceModel\Jobs::class);
    }

    /**
     * @return array|mixed|null
     */
    public function getId()
    {
        return $this->getData(self::ID);
    }

    /**
     * @param mixed $id
     * @return $this|Jobs|mixed
     */
    public function setId($id)
    {
        $this->setData(self::ID, $id);
        return $this;
    }

    /**
     * @return mixed|void
     */
    public function getType()
    {
        return $this->getData(self::TYPE);
    }

    /**
     * @param $type
     * @return mixed|void
     */
    public function setType($type)
    {
        $this->setData(self::TYPE, $type);
        return $this;
    }

    /**
     * @return mixed|void
     */
    public function getDirection()
    {
        return $this->getData(self::DIRECTION);
    }

    /**
     * @param $direction
     * @return mixed|void
     */
    public function setDirection($direction)
    {
        $this->setData(self::DIRECTION, $direction);
        return $this;
    }

    /**
     * @return mixed|void
     */
    public function getEntity()
    {
        return $this->getData(self::ENTITY);
    }

    /**
     * @param $entity
     * @return mixed|void
     */
    public function setEntity($entity)
    {
        $this->setData(self::ENTITY, $entity);
        return $this;
    }

    /**
     * @return mixed|void
     */
    public function getEntityId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @param int $entityId
     * @return Jobs|mixed|void
     */
    public function setEntityId($entityId)
    {
        $this->setData(self::ENTITY_ID, $entityId);
        return $this;
    }

    /**
     * @return mixed|void
     */
    public function getRequest()
    {
        return $this->getData(self::REQUEST);
    }

    /**
     * @param $request
     * @return mixed|void
     */
    public function setRequest($request)
    {
        $this->setData(self::REQUEST, $request);
        return $this;
    }

    /**
     * @return mixed|void
     */
    public function getResponse()
    {
        return $this->getData(self::RESPONSE);
    }

    /**
     * @param $response
     * @return mixed|void
     */
    public function setResponse($response)
    {
        $this->setData(self::RESPONSE, $response);
        return $this;
    }

    /**
     * @return mixed|void
     */
    public function getStatus()
    {
        return $this->getData(self::STATUS);
    }

    /**
     * @param $status
     * @return mixed|void
     */
    public function setStatus($status)
    {
        $this->setData(self::STATUS, $status);
        return $this;
    }

    /**
     * @return mixed|void
     */
    public function getLog()
    {
        return $this->getData(self::LOG);
    }

    /**
     * @param $log
     * @return mixed|void
     */
    public function setLog($log)
    {
        $this->setData(self::LOG, $log);
        return $this;
    }
}