<?php

namespace FiloBlu\ActiveCampaign\Model;

use FiloBlu\ActiveCampaign\Api\Data\FieldsInterface;
use FiloBlu\ActiveCampaign\Api\Data\FieldsInterfaceFactory;
use FiloBlu\ActiveCampaign\Api\FieldsRepositoryInterface;
use FiloBlu\ActiveCampaign\Helper\Data;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Phrase;
use Zend_Db;

/**
 * Class FieldsRepository
 * @package FiloBlu\ActiveCampaign\Model
 */
class FieldsRepository implements FieldsRepositoryInterface
{
    /**
     * @var ResourceConnection
     */
    protected $resourceConnection;
    /**
     * @var Data
     */
    protected $helperData;
    /**
     * @var FieldsInterfaceFactory
     */
    protected $fieldsFactory;


    /**
     * JobsRepository constructor.
     * @param ResourceConnection $resourceConnection
     * @param FieldsInterfaceFactory $fieldsFactory
     * @param Data $helperData
     */
    public function __construct(
        ResourceConnection $resourceConnection,
        FieldsInterfaceFactory $fieldsFactory,
        Data $helperData
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->helperData = $helperData;
        $this->fieldsFactory = $fieldsFactory;
    }


    /**
     * @param FieldsInterface $fields
     * @return mixed|void
     */
    public function save(FieldsInterface $fields)
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(FieldsInterface::DB_TABLE);
        $connection->insert(
            $table,
            [
                FieldsInterface::AC_ID => $fields->getAcId(),
                FieldsInterface::NAME => $fields->getName()
            ]
        );

        $id = $connection->lastInsertId();
        $fields->setId($id);
    }

    /**
     * @param $fieldId
     * @return mixed
     * @throws NoSuchEntityException
     */
    public function getById($fieldId)
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(FieldsInterface::DB_TABLE);
        $sql = $connection->select()->from($table, ['*'])->where('id = (?)', $fieldId)->assemble();
        $res = $connection->fetchRow($sql, [], Zend_Db::FETCH_ASSOC);
        if ($res===null) {
            throw new NoSuchEntityException(new Phrase('The list with id ' . $fieldId . ' doesn\'t exists'));
        }
        $lists = $this->fieldsFactory->create();
        foreach ($res as $k => $v) {
            $parse = explode('_', $k);
            $method = 'set';
            foreach ($parse as $p) {
                $method .= ucwords($p);
            }
            $lists->{$method}($v);
        }
        return $lists;
    }

    /**
     * @return array|mixed
     */
    public function getAll()
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(FieldsInterface::DB_TABLE);
        $sql = $connection->select()->from($table, ['*'])->assemble();
        return $connection->fetchAll($sql, [], Zend_Db::FETCH_ASSOC);
    }

    /**
     * @param $fieldId
     * @return mixed|void
     */
    public function deleteById($fieldId)
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(FieldsInterface::DB_TABLE);
        $sql = $connection->delete($table,'id = '.$fieldId);
    }

    /**
     * @return mixed|void
     */
    public function deleteAll()
    {
        $connection = $this->resourceConnection->getConnection();
        $table = $connection->getTableName(FieldsInterface::DB_TABLE);
        $sql = $connection->delete($table);
    }
}
