<?php

namespace FiloBlu\ActiveCampaign\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class EntityType
 * @package FiloBlu\ActiveCampaign\Model\Config\Source
 */
class EntityType implements OptionSourceInterface
{
    /**
     * Constants
     */
    const ENTITY_CUSTOMER = "customer";
    const ENTITY_SUBSCRIBER = "subscriber";
    const ENTITY_QUOTE = "quote";
    const ENTITY_ORDER = "order";
    const ENTITY_AVAILABLE = [self::ENTITY_CUSTOMER,self::ENTITY_SUBSCRIBER,self::ENTITY_QUOTE,self::ENTITY_ORDER];

    /**
     * @return array|array[]
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::ENTITY_CUSTOMER, 'label' => __('Customer')],
            ['value' => self::ENTITY_SUBSCRIBER, 'label' => __('Subscriber')],
            ['value' => self::ENTITY_QUOTE, 'label' => __('Quote')],
            ['value' => self::ENTITY_ORDER, 'label' => __('Order')]
        ];
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return [
            self::ENTITY_CUSTOMER => __('Customer'),
            self::ENTITY_SUBSCRIBER => __('Subscriber'),
            self::ENTITY_QUOTE => __('Quote'),
            self::ENTITY_ORDER => __('Order')
        ];
    }
}
