<?php

namespace FiloBlu\ActiveCampaign\Controller\Adminhtml\Jobs;

use FiloBlu\ActiveCampaign\Model\Jobs;
use Magento\Backend\App\Action;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultInterface;

/**
 * Class MassDelete
 * @package FiloBlu\ActiveCampaign\Controller\Adminhtml\Jobs
 */
class MassDelete extends Action
{
    /**
     * @return ResponseInterface|Redirect|ResultInterface
     */
    public function execute()
    {
        $ids = $this->getRequest()->getParam('selected');

        try {
            foreach ($ids as $id) {
                $row = $this->_objectManager->create(Jobs::class)->load($id);
                $row->delete();
            }
            $this->messageManager->addSuccessMessage(__('A total of %1 record(s) have been deleted.', count($ids)));
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('Error while trying to delete jobs: ' . $e->getMessage()));
            $resultRedirect = $this->resultRedirectFactory->create();
            return $resultRedirect->setPath('*/*/index', ['_current' => true]);
        }

        $resultRedirect = $this->resultRedirectFactory->create();
        return $resultRedirect->setPath('*/*/index', ['_current' => true]);
    }
}
