<?php

namespace FiloBlu\ActiveCampaign\Controller\Adminhtml\Config;

use Exception;
use FiloBlu\ActiveCampaign\Api\Data\ListsInterfaceFactory;
use FiloBlu\ActiveCampaign\Api\ListsRepositoryInterface;
use FiloBlu\ActiveCampaign\Helper\Data;
use FiloBlu\ActiveCampaign\Model\Resource\ActiveCampaign;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\Json;
use Magento\Framework\Controller\Result\JsonFactory;
use Throwable;

/**
 *
 */
class Sync extends Action
{

    /**
     * @var JsonFactory
     */
    protected $resultJsonFactory;
    /**
     * @var Data
     */
    protected $helperData;
    /**
     * @var ActiveCampaign
     */
    protected $activeCampaign;
    /**
     * @var ListsInterfaceFactory
     */
    protected $listsFactory;
    /**
     * @var ListsRepositoryInterface
     */
    protected $listsRepository;

    /**
     * @param Context $context
     * @param JsonFactory $resultJsonFactory
     * @param Data $helperData
     * @param ActiveCampaign $activeCampaign
     * @param ListsInterfaceFactory $listsFactory
     * @param ListsRepositoryInterface $listsRepository
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        Data $helperData,
        ActiveCampaign $activeCampaign,
        ListsInterfaceFactory $listsFactory,
        ListsRepositoryInterface $listsRepository
    ) {
        $this->resultJsonFactory = $resultJsonFactory;
        $this->helperData = $helperData;
        $this->activeCampaign = $activeCampaign;
        $this->listsFactory = $listsFactory;
        $this->listsRepository = $listsRepository;
        parent::__construct($context);
    }

    /**
     * Collect relations data
     *
     * @return Json
     * @throws Exception
     */
    public function execute()
    {
        try {
            $listResponse = $this->activeCampaign->getLists();
            $lists = $listResponse['lists'];

            if (count($lists) == 0) {
                return $this->resultJsonFactory->create()->setData(['success' => true, 'message' => '0 lists synced']);
            }
            $this->listsRepository->deleteAll();
            foreach ($lists as $list) {
                $l = $this->listsFactory->create();
                $l->setAcId($list['id'])->setName($list['name']);
                $this->listsRepository->save($l);
            }

            return $this->resultJsonFactory->create()->setData(
                ['success' => true, 'message' => count($lists) . ' lists synced']
            );
        } catch (Exception $exception) {
            return $this->resultJsonFactory->create()->setData(
                ['success' => false, 'message' => $exception->getMessage()]
            );
        } catch (Throwable $throwable) {
            return $this->resultJsonFactory->create()->setData(
                ['success' => false, 'message' => $throwable->getMessage()]
            );
        }
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_ActiveCampaign::config');
    }
}