<?php

namespace FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\Newsletter;

use FiloBlu\ActiveCampaign\Api\FieldsRepositoryInterface;
use FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\AbstractConfig;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\App\ResourceConnection;
use Magento\Newsletter\Model\Subscriber as MagentoSubscriber;

/**
 * Class Subscriber
 * @package FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\Newsletter
 */
class Subscriber extends AbstractConfig
{

    /**
     * Product Model
     *
     * @var MagentoSubscriber
     */
    protected $model;

    /**
     * @var string
     */
    protected $id = 'subscriber';

    /**
     * @var string
     */
    protected $type = 'flat';

    /**
     * @var array
     */
    protected $exclude = ['subscriber_email'];

    /**
     * @var array
     */
    protected $additionalOptions =  [
        ['value' => '_store_code', 'label' => '_store_code (Store Code)'],
        ['value' => '_store_name', 'label' => '_store_name (Store Name)'],
        ['value' => '_website_code', 'label' => '_website_code (Website Code)'],
        ['value' => '_website_name', 'label' => '_website_name (Website Name)'],
        ['value' => '_action', 'label' => '_action (Action)'],
        ['value' => '_type', 'label' => '_type (Type)'],
        ['value' => '_language', 'label' => '_language (Language Normalized)'],
        ['value' => '_language_iso2', 'label' => '_language ISO2 (Language ISO2 Normalized)'],
        ['value' => '_source', 'label' => '_source (Source Normalized)'],
        ['value' => '_subscriber_status_normalized', 'label' => '_subscriber_status_normalized (Subscriber Status Normalized)'],
        ['value' => '_dob_normalized', 'label' => '_dob_normalized (DOB Normalized)'],
        ['value' => '_gender_normalized', 'label' => '_gender_normalized (Gender Normalized)'],
        ['value' => '_created_at_normalized', 'label' => '_created_at_normalized (Subscriber Created At Normalized)'],
        ['value' => '_updated_at_normalized', 'label' => '_updated_at_normalized (Subscriber Updated At Normalized)'],
        //['value' => 'dob', 'label' => 'dob (Date of birth - Newsletter Extension)'],
        ['value' => 'country', 'label' => 'country (Country - Newsletter Extension)'],
        //['value' => 'source', 'label' => 'source (Source - Newsletter Extension)'],
        //['value' => 'language', 'label' => 'language (Language - Newsletter Extension)'],
        //['value' => 'website_name', 'label' => 'website_name (Website Name - Newsletter Extension)'],
        //['value' => 'gender', 'label' => 'gender (Gender - Newsletter Extension)'],
        ['value' => 'collections', 'label' => 'collections (Collections - Newsletter Extension)'],
        ['value' => 'birthday', 'label' => 'birthday (Birthday - Newsletter Extension)'],
        //['value' => 'created_at', 'label' => 'created_at (Created At - Newsletter Extension)'],
        //['value' => 'updated_at', 'label' => 'updated_at (Updated At - Newsletter Extension)'],
        //['value' => 'customer_created_at', 'label' => 'customer_created_at (Customer Created At)']

    ];

    /**
     * Attributes constructor.
     * @param MagentoSubscriber $subscriber
     * @param Context $context
     * @param ResourceConnection $resourceConnection
     * @param FieldsRepositoryInterface $fieldsRepository
     * @param array $data
     */
    public function __construct(
        MagentoSubscriber $subscriber,
        Context $context,
        ResourceConnection $resourceConnection,
        FieldsRepositoryInterface $fieldsRepository,
        array $data = []
    ) {
        $this->model = $subscriber;
        parent::__construct($context, $resourceConnection, $fieldsRepository, $data);
    }

}
