<?php

namespace FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\Customer;

use FiloBlu\ActiveCampaign\Api\FieldsRepositoryInterface;
use FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\AbstractConfig;
use Magento\Backend\Block\Template\Context;
use Magento\Customer\Model\Address;
use Magento\Framework\App\ResourceConnection;

/**
 * Class CustomerShippingAddress
 * @package FiloBlu\ActiveCampaign\Block\Adminhtml\System\Config\Customer
 */
class CustomerShippingAddress extends AbstractConfig
{

    /**
     * @var Address
     */
    protected $model;

    /**
     * @var string
     */
    protected $id = 'customer_shipping_address';

    /**
     * @var string
     */
    protected $type = 'eav';

    /**
     * @var array
     */
    protected $exclude = ['increment_id','entity_id','entity_type_id','parent_id','attribute_set_id','firstname','lastname','middlename'];

    /**
     * CustomerAttributes constructor.
     * @param Address $address
     * @param Context $context
     * @param ResourceConnection $resourceConnection
     * @param FieldsRepositoryInterface $fieldsRepository
     * @param array $data
     */
    public function __construct(
        Address $address,
        Context $context,
        ResourceConnection $resourceConnection,
        FieldsRepositoryInterface $fieldsRepository,
        array $data = []
    ) {
        $this->model = $address;
        parent::__construct($context, $resourceConnection, $fieldsRepository, $data);
    }
}
