<?php

namespace FiloBlu\ActiveCampaign\Api;

use FiloBlu\ActiveCampaign\Api\Data\FieldsInterface;

/**
 * Interface FieldsRepositoryInterface
 * @package FiloBlu\ActiveCampaign\Api
 */
interface FieldsRepositoryInterface
{
    /**
     * @param FieldsInterface $lists
     * @return mixed
     */
    public function save(FieldsInterface $lists);

    /**
     * @param $fieldId
     * @return mixed
     */
    public function getById($fieldId);

    /**
     * @return mixed
     */
    public function getAll();

    /**
     * @param $fieldId
     * @return mixed
     */
    public function deleteById($fieldId);

    /**
     * @return mixed
     */
    public function deleteAll();

}
